/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.coregen.populatordata;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.coregen.NaturalSpawnType;
import org.terraform.coregen.TerraLootTable;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.IPopulatorDataPhysicsCapable;
import org.terraform.coregen.populatordata.PopulatorDataICAAbstract;
import org.terraform.coregen.populatordata.PopulatorDataICABiomeWriterAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;

public class PopulatorDataPostGen
extends PopulatorDataICABiomeWriterAbstract
implements IPopulatorDataPhysicsCapable {
    private final World w;
    private final Chunk c;
    private static int spawnerRetries = 0;

    public PopulatorDataPostGen(Chunk c2) {
        this.w = c2.getWorld();
        this.c = c2;
    }

    public World getWorld() {
        return this.w;
    }

    public Chunk getChunk() {
        return this.c;
    }

    @Override
    public Material getType(int x, int y, int z) {
        return this.w.getBlockAt(x, y, z).getType();
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        return this.w.getBlockAt(x, y, z).getBlockData();
    }

    @Override
    public void setType(int x, int y, int z, Material type) {
        boolean isFragile = Tag.DOORS.isTagged((Keyed)type) || Tag.CARPETS.isTagged((Keyed)type) || type == Material.FARMLAND || type == Material.WATER;
        Block b = this.w.getBlockAt(x, y, z);
        b.setType(type, !isFragile);
    }

    @Override
    public void setBlockData(int x, int y, int z, BlockData data) {
        boolean isFragile = Tag.DOORS.isTagged((Keyed)data.getMaterial()) || Tag.CARPETS.isTagged((Keyed)data.getMaterial()) || data.getMaterial() == Material.FARMLAND || data.getMaterial() == Material.WATER;
        Block b = this.w.getBlockAt(x, y, z);
        b.setBlockData(data.clone(), !isFragile);
    }

    @Override
    public void setType(int x, int y, int z, Material type, boolean updatePhysics) {
        Block b = this.w.getBlockAt(x, y, z);
        b.setType(type, updatePhysics);
    }

    @Override
    public void setBlockData(int x, int y, int z, BlockData data, boolean updatePhysics) {
        Block b = this.w.getBlockAt(x, y, z);
        b.setBlockData(data.clone(), updatePhysics);
    }

    public BlockState getBlockState(int x, int y, int z) {
        Block b = this.w.getBlockAt(x, y, z);
        return b.getState();
    }

    public void noPhysicsUpdateForce(int x, int y, int z, BlockData data) {
        Block b = this.w.getBlockAt(x, y, z);
        b.setBlockData(data.clone(), false);
    }

    @Override
    public Biome getBiome(int rawX, int rawZ) {
        return this.w.getBlockAt(rawX, TerraformGenerator.seaLevel, rawZ).getBiome();
    }

    @Override
    public void setBiome(int rawX, int rawY, int rawZ, Biome biome) {
        this.w.setBiome(rawX, rawY, rawZ, biome);
    }

    @Override
    public int getChunkX() {
        return this.c.getX();
    }

    @Override
    public int getChunkZ() {
        return this.c.getZ();
    }

    @Override
    public void addEntity(int x, int y, int z, EntityType type) {
        Entity e = this.c.getWorld().spawnEntity(new Location(this.c.getWorld(), (double)x + 0.5, (double)y + 0.3, (double)z + 0.5), type);
        e.setPersistent(true);
    }

    @Override
    public void setSpawner(int rawX, int rawY, int rawZ, EntityType type) {
        Block b = this.w.getBlockAt(rawX, rawY, rawZ);
        b.setType(Material.SPAWNER, false);
        try {
            CreatureSpawner spawner = (CreatureSpawner)b.getState();
            spawner.setSpawnedType(type);
            spawner.update();
        }
        catch (ClassCastException | IllegalStateException e) {
            if (++spawnerRetries > 10) {
                Bukkit.getLogger().info("Giving up on spawner at " + rawX + "," + rawY + "," + rawZ);
                spawnerRetries = 0;
                return;
            }
            Bukkit.getLogger().info("Failed to get state for spawner at " + rawX + "," + rawY + "," + rawZ + ", try " + spawnerRetries);
            this.setSpawner(rawX, rawY, rawZ, type);
        }
    }

    @Override
    public void lootTableChest(int x, int y, int z, TerraLootTable table) {
        TerraformGeneratorPlugin.injector.getICAData(this.w.getBlockAt(x, y, z).getChunk()).lootTableChest(x, y, z, table);
    }

    @Override
    public TerraformWorld getTerraformWorld() {
        return TerraformWorld.get(this.w);
    }

    @Override
    public void setBiome(int rawX, int rawY, int rawZ, CustomBiomeType cbt, Biome fallback) {
        PopulatorDataICAAbstract icad = TerraformGeneratorPlugin.injector.getICAData(this.w.getBlockAt(rawX, rawY, rawZ).getChunk());
        if (icad instanceof PopulatorDataICABiomeWriterAbstract) {
            ((PopulatorDataICABiomeWriterAbstract)icad).setBiome(rawX, rawY, rawZ, cbt, fallback);
        }
    }

    @Override
    public void registerNaturalSpawns(NaturalSpawnType type, int x0, int y0, int z0, int x1, int y1, int z1) {
        PopulatorDataICAAbstract icad = TerraformGeneratorPlugin.injector.getICAData(this.w.getBlockAt(x0, y0, z0).getChunk());
        if (icad instanceof PopulatorDataICABiomeWriterAbstract) {
            ((PopulatorDataICABiomeWriterAbstract)icad).registerNaturalSpawns(type, x0, y0, z0, x1, y1, z1);
        }
    }

    @Override
    public void spawnMinecartWithChest(int x, int y, int z, TerraLootTable table, Random random) {
        PopulatorDataICAAbstract icad = TerraformGeneratorPlugin.injector.getICAData(this.w.getBlockAt(x, y, z).getChunk());
        if (icad instanceof PopulatorDataICABiomeWriterAbstract) {
            ((PopulatorDataICABiomeWriterAbstract)icad).spawnMinecartWithChest(x, y, z, table, random);
        }
    }
}

