/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.coregen.bukkit;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.generator.BlockPopulator;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.coregen.populatordata.PopulatorDataPostGen;
import org.terraform.data.MegaChunk;
import org.terraform.data.TerraformWorld;
import org.terraform.event.TerraformStructureSpawnEvent;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.structure.MultiMegaChunkStructurePopulator;
import org.terraform.structure.SingleMegaChunkStructurePopulator;
import org.terraform.structure.StructurePopulator;
import org.terraform.structure.StructureRegistry;
import org.terraform.structure.stronghold.StrongholdPopulator;

public class TerraformStructurePopulator
extends BlockPopulator {
    private final TerraformWorld tw;

    public TerraformStructurePopulator(TerraformWorld tw) {
        this.tw = tw;
    }

    public void populate(World world, Random random, Chunk chunk) {
        int[] chunkCoords;
        if (!TerraformGeneratorPlugin.INJECTED_WORLDS.contains(world.getName())) {
            return;
        }
        PopulatorDataPostGen data = new PopulatorDataPostGen(chunk);
        MegaChunk mc = new MegaChunk(chunk.getX(), chunk.getZ());
        BiomeBank biome = mc.getCenterBiomeSection(this.tw).getBiomeBank();
        if (new StrongholdPopulator().canSpawn(this.tw, data.getChunkX(), data.getChunkZ(), biome)) {
            TerraformGeneratorPlugin.logger.info("Generating Stronghold at chunk: " + data.getChunkX() + "," + data.getChunkZ());
            new StrongholdPopulator().populate(this.tw, data);
        }
        if ((chunkCoords = mc.getCenterBiomeSectionChunkCoords())[0] == data.getChunkX() && chunkCoords[1] == data.getChunkZ()) {
            int[] blockCoords = mc.getCenterBiomeSectionBlockCoords();
            for (SingleMegaChunkStructurePopulator spop : StructureRegistry.getLargeStructureForMegaChunk(this.tw, mc)) {
                if (spop == null || !spop.isEnabled() || spop instanceof StrongholdPopulator || !spop.canSpawn(this.tw, data.getChunkX(), data.getChunkZ(), biome)) continue;
                TerraformGeneratorPlugin.logger.info("Generating " + spop.getClass().getName() + " at chunk: " + data.getChunkX() + "," + data.getChunkZ());
                Bukkit.getPluginManager().callEvent((Event)new TerraformStructureSpawnEvent(blockCoords[0], blockCoords[1], spop.getClass().getName()));
                spop.populate(this.tw, data);
                break;
            }
        }
    }

    public void spawnMultiMegaChunkStructures(PopulatorDataAbstract data) {
        for (StructurePopulator structurePopulator : StructureRegistry.smallStructureRegistry) {
            if (!((MultiMegaChunkStructurePopulator)structurePopulator).canSpawn(this.tw, data.getChunkX(), data.getChunkZ())) continue;
            TerraformGeneratorPlugin.logger.info("Generating " + structurePopulator.getClass().getName() + " at chunk: " + data.getChunkX() + "," + data.getChunkZ());
            structurePopulator.populate(this.tw, data);
        }
    }
}

