/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.coregen.bukkit;

import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.biome.custombiomes.CustomBiomeSupportedBiomeGrid;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.coregen.ChunkCache;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformChunkData;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleChunkLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneSevenBlockHandler;
import org.terraform.utils.version.Version;

public class TerraformGenerator
extends ChunkGenerator {
    public static final List<SimpleChunkLocation> preWorldInitGen = new ArrayList<SimpleChunkLocation>();
    private static final Object LOCK = new Object();
    public static LoadingCache<ChunkCache, ChunkCache> CHUNK_CACHE;
    public static int seaLevel;
    ConcurrentHashMap<SimpleChunkLocation, PopulatorDataAbstract> generatorDataAccess = new ConcurrentHashMap();

    public static void updateSeaLevelFromConfig() {
        seaLevel = TConfigOption.HEIGHT_MAP_SEA_LEVEL.getInt();
    }

    public static ChunkCache getCache(TerraformWorld tw, int x, int z) {
        ChunkCache cache = new ChunkCache(tw, x, 0, z);
        try {
            return (ChunkCache)CHUNK_CACHE.get((Object)cache);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            e.getCause().printStackTrace();
            cache.initInternalCache();
            return cache;
        }
    }

    public boolean isParallelCapable() {
        return true;
    }

    public void addPopulatorData(PopulatorDataAbstract data) {
        this.generatorDataAccess.put(new SimpleChunkLocation(data.getTerraformWorld().getName(), data.getChunkX(), data.getChunkZ()), data);
    }

    protected ChunkGenerator.ChunkData createChunkData(World world, int chunkX, int chunkZ) {
        if (Version.isAtLeast(18.0)) {
            PopulatorDataAbstract data = this.generatorDataAccess.remove(new SimpleChunkLocation(world.getName(), chunkX, chunkZ));
            if (data == null) {
                throw new IllegalArgumentException("Requested for chunkX and Z that weren't in the concurrenthashmap!");
            }
            return new TerraformChunkData(data);
        }
        return super.createChunkData(world);
    }

    private int getVanillaGeneratedHeight(TerraformWorld tw, ChunkGenerator.ChunkData chunk, int x, int z) {
        int y;
        for (y = tw.maxY; y > tw.minY && !chunk.getType(x, y, z).isSolid(); --y) {
        }
        return y;
    }

    public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int chunkX, int chunkZ, ChunkGenerator.BiomeGrid biome) {
        TerraformGeneratorPlugin.watchdogSuppressant.tickWatchdog();
        ChunkGenerator.ChunkData chunk = this.createChunkData(world, chunkX, chunkZ);
        TerraformWorld tw = TerraformWorld.get(world);
        if (!TerraformGeneratorPlugin.INJECTED_WORLDS.contains(world.getName())) {
            preWorldInitGen.add(new SimpleChunkLocation(world.getName(), chunkX, chunkZ));
        }
        boolean newLogic = Version.isAtLeast(18.0);
        ArrayList<BiomeHandler> biomesToTransform = new ArrayList<BiomeHandler>();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int rawX = chunkX * 16 + x;
                int rawZ = chunkZ * 16 + z;
                int height = HeightMap.getBlockHeight(tw, rawX, rawZ);
                BiomeBank bank = BiomeBank.calculateBiome(tw, rawX, height, rawZ);
                Material[] crust = bank.getHandler().getSurfaceCrust(random);
                if (newLogic) {
                    int vanillaHeight = this.getVanillaGeneratedHeight(tw, chunk, x, z);
                    if (rawX == -89 && rawZ == 55) {
                        TerraformGeneratorPlugin.logger.info("getVanillaGeneratedHeight (-89, 55): " + vanillaHeight + " vs " + height);
                    }
                    if (vanillaHeight < height) {
                        for (y = vanillaHeight; y <= height; ++y) {
                            if (chunk.getType(x, y, z) == Material.CAVE_AIR) continue;
                            this.setBlockSync(chunk, x, y, z, Material.STONE);
                        }
                    } else if (vanillaHeight > height) {
                        for (y = vanillaHeight; y > height; --y) {
                            this.setBlockSync(chunk, x, y, z, Material.AIR);
                        }
                    }
                } else if (bank.getHandler().getCustomBiome() != CustomBiomeType.NONE && biome instanceof CustomBiomeSupportedBiomeGrid) {
                    ((CustomBiomeSupportedBiomeGrid)biome).setBiome(tw, x, z, bank.getHandler().getCustomBiome(), bank.getHandler().getBiome());
                } else {
                    biome.setBiome(x, z, bank.getHandler().getBiome());
                }
                int undergroundHeight = height;
                int index = 0;
                while (index < crust.length) {
                    this.setBlockSync(chunk, x, undergroundHeight, z, crust[index]);
                    ++index;
                    --undergroundHeight;
                }
                for (int y = undergroundHeight; y > tw.minY; --y) {
                    if (!chunk.getType(x, y, z).isSolid() && newLogic) continue;
                    if (y > 2) {
                        this.setBlockSync(chunk, x, y, z, Material.STONE);
                        continue;
                    }
                    if (y > 0 && y <= 2) {
                        this.setBlockSync(chunk, x, y, z, GenUtils.randMaterial(OneOneSevenBlockHandler.DEEPSLATE, Material.STONE));
                        continue;
                    }
                    this.setBlockSync(chunk, x, y, z, OneOneSevenBlockHandler.DEEPSLATE);
                }
                if (!newLogic) {
                    this.fillSeaAndRivers(chunk, x, z, height);
                }
                this.setBlockSync(chunk, x, tw.minY, z, Material.BEDROCK);
                for (int i = 1; i < TConfigOption.HEIGHT_MAP_BEDROCK_HEIGHT.getInt() && GenUtils.chance(random, TConfigOption.HEIGHT_MAP_BEDROCK_DENSITY.getInt(), 100); ++i) {
                    this.setBlockSync(chunk, x, tw.minY + i, z, Material.BEDROCK);
                }
                BiomeHandler transformHandler = bank.getHandler().getTransformHandler();
                if (transformHandler == null || biomesToTransform.contains(transformHandler)) continue;
                biomesToTransform.add(transformHandler);
            }
        }
        for (BiomeHandler handler : biomesToTransform) {
            handler.transformTerrain(tw, random, chunk, biome, chunkX, chunkZ);
        }
        return chunk;
    }

    public void fillSeaAndRivers(ChunkGenerator.ChunkData chunk, int x, int z, int height) {
        int y;
        int realLandHeight = seaLevel;
        for (y = seaLevel; y > height; --y) {
            if (!chunk.getType(x, y, z).isSolid()) continue;
            realLandHeight = y;
            break;
        }
        if (height > seaLevel && height > realLandHeight) {
            return;
        }
        for (y = seaLevel; y > TerraformGeneratorPlugin.injector.getMinY() && !chunk.getType(x, y, z).isSolid(); --y) {
            this.setBlockSync(chunk, x, y, z, Material.WATER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBlockSync(ChunkGenerator.ChunkData data, int x, int y, int z, Material material) {
        if (Version.isAtLeast(18.0)) {
            data.setBlock(x, y, z, material);
        } else {
            Object object = LOCK;
            synchronized (object) {
                data.setBlock(x, y, z, material);
            }
        }
    }

    public Location getFixedSpawnLocation(World world, Random random) {
        return new Location(world, 0.0, (double)HeightMap.getBlockHeight(TerraformWorld.get(world), 0, 0), 0.0);
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        TerraformWorld tw = TerraformWorld.get(world);
        return Collections.singletonList(tw.getBukkitBlockPopulator());
    }

    public boolean shouldGenerateNoise() {
        return true;
    }

    public boolean shouldGenerateSurface() {
        return false;
    }

    public boolean shouldGenerateBedrock() {
        return false;
    }

    public boolean shouldGenerateCaves() {
        return true;
    }

    public boolean shouldGenerateDecorations() {
        return true;
    }

    public boolean shouldGenerateMobs() {
        return false;
    }

    public boolean shouldGenerateStructures() {
        return false;
    }

    static {
        seaLevel = 62;
    }
}

