/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.coregen.bukkit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.terraform.data.SimpleChunkLocation;
import org.terraform.data.SimpleLocation;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;

public class PhysicsUpdaterPopulator
extends BlockPopulator
implements Listener {
    private static boolean flushIsQueued = false;
    public static Map<SimpleChunkLocation, Collection<SimpleLocation>> cache = new ConcurrentHashMap<SimpleChunkLocation, Collection<SimpleLocation>>();

    public PhysicsUpdaterPopulator() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)TerraformGeneratorPlugin.get());
    }

    public static void pushChange(String world, SimpleLocation loc) {
        SimpleChunkLocation scl;
        if (!flushIsQueued && cache.size() > TConfigOption.DEVSTUFF_FLUSH_PATCHER_CACHE_FREQUENCY.getInt()) {
            flushIsQueued = true;
            new BukkitRunnable(){

                public void run() {
                    PhysicsUpdaterPopulator.flushChanges();
                    flushIsQueued = false;
                }
            }.runTask((Plugin)TerraformGeneratorPlugin.get());
        }
        if (!cache.containsKey(scl = new SimpleChunkLocation(world, loc.getX(), loc.getY(), loc.getZ()))) {
            cache.put(scl, new ArrayList());
        }
        cache.get(scl).add(loc);
    }

    public static void flushChanges() {
        if (cache.size() == 0) {
            return;
        }
        TerraformGeneratorPlugin.logger.info("[PhysicsUpdaterPopulator] Flushing repairs (" + cache.size() + " chunks)");
        ArrayList<SimpleChunkLocation> locs = new ArrayList<SimpleChunkLocation>();
        for (SimpleChunkLocation scl : cache.keySet()) {
            locs.add(scl);
        }
        for (SimpleChunkLocation scl : locs) {
            World w = Bukkit.getWorld((String)scl.getWorld());
            if (w == null) continue;
            if (w.isChunkLoaded(scl.getX(), scl.getZ())) {
                Collection<SimpleLocation> changes = cache.remove(scl);
                if (changes == null) continue;
                for (SimpleLocation entry : changes) {
                    Block target = w.getBlockAt(entry.getX(), entry.getY(), entry.getZ());
                    BlockData old = target.getBlockData();
                    TerraformGeneratorPlugin.logger.info("[PhysicsUpdaterPopulator] " + target.getLocation().toString());
                    target.setType(Material.AIR);
                    target.setBlockData(old, true);
                }
                continue;
            }
            w.loadChunk(scl.getX(), scl.getZ());
        }
    }

    public void populate(World world, Random random, Chunk chunk) {
        SimpleChunkLocation scl = new SimpleChunkLocation(chunk);
        Collection<SimpleLocation> changes = cache.remove(scl);
        if (changes != null) {
            for (SimpleLocation entry : changes) {
                Block target = world.getBlockAt(entry.getX(), entry.getY(), entry.getZ());
                BlockData old = target.getBlockData();
                target.setType(Material.AIR);
                target.setBlockData(old, true);
            }
        }
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        TerraformGeneratorPlugin.logger.info("[PhysicsUpdaterPopulator] Flushing repairs for " + event.getWorld().getName() + " (" + cache.size() + " chunks in cache)");
        int processed = 0;
        for (SimpleChunkLocation scl : cache.keySet()) {
            if (!scl.getWorld().equals(event.getWorld().getName())) continue;
            Collection<SimpleLocation> changes = cache.remove(scl);
            if (changes != null) {
                for (SimpleLocation entry : changes) {
                    Block target = event.getWorld().getBlockAt(entry.getX(), entry.getY(), entry.getZ());
                    BlockData old = target.getBlockData();
                    target.setType(Material.AIR);
                    target.setBlockData(old, true);
                }
            }
            if (++processed % 20 != 0) continue;
            TerraformGeneratorPlugin.logger.info("[PhysicsUpdaterPopulator] Processed " + processed + " more chunks");
        }
    }
}

