/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.coregen;

import java.util.EnumSet;
import java.util.Random;
import org.bukkit.Material;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.cave.MasterCavePopulatorDistributor;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.populators.AmethystGeodePopulator;
import org.terraform.populators.OrePopulator;
import org.terraform.structure.MultiMegaChunkStructurePopulator;
import org.terraform.structure.StructureBufferDistanceHandler;
import org.terraform.structure.StructurePopulator;
import org.terraform.structure.StructureRegistry;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneSevenBlockHandler;
import org.terraform.utils.version.OrePopulatorFallbackSettings;
import org.terraform.utils.version.Version;

public class TerraformPopulator {
    private static final OrePopulator[] ORE_POPS = new OrePopulator[]{null, null, null, new OrePopulator(Material.COAL_ORE, TConfigOption.ORE_COAL_CHANCE.getInt(), TConfigOption.ORE_COAL_VEINSIZE.getInt(), TConfigOption.ORE_COAL_MAXVEINNUMBER.getInt(), TConfigOption.ORE_COAL_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_COAL_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_COAL_MAXSPAWNHEIGHT.getInt(), false, new BiomeBank[0]), new OrePopulator(Material.IRON_ORE, TConfigOption.ORE_IRON_CHANCE.getInt(), TConfigOption.ORE_IRON_VEINSIZE.getInt(), TConfigOption.ORE_IRON_MAXVEINNUMBER.getInt(), TConfigOption.ORE_IRON_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_IRON_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_IRON_MAXSPAWNHEIGHT.getInt(), false, new BiomeBank[0]), new OrePopulator(Material.GOLD_ORE, TConfigOption.ORE_GOLD_CHANCE.getInt(), TConfigOption.ORE_GOLD_VEINSIZE.getInt(), TConfigOption.ORE_GOLD_MAXVEINNUMBER.getInt(), TConfigOption.ORE_GOLD_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_GOLD_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_GOLD_MAXSPAWNHEIGHT.getInt(), false, new BiomeBank[0]), new OrePopulator(Material.DIAMOND_ORE, TConfigOption.ORE_DIAMOND_CHANCE.getInt(), TConfigOption.ORE_DIAMOND_VEINSIZE.getInt(), TConfigOption.ORE_DIAMOND_MAXVEINNUMBER.getInt(), TConfigOption.ORE_DIAMOND_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_DIAMOND_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_DIAMOND_MAXSPAWNHEIGHT.getInt(), false, new BiomeBank[0]), new OrePopulator(Material.EMERALD_ORE, TConfigOption.ORE_EMERALD_CHANCE.getInt(), TConfigOption.ORE_EMERALD_VEINSIZE.getInt(), TConfigOption.ORE_EMERALD_MAXVEINNUMBER.getInt(), TConfigOption.ORE_EMERALD_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_EMERALD_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_EMERALD_MAXSPAWNHEIGHT.getInt(), false, BiomeBank.BIRCH_MOUNTAINS, BiomeBank.ROCKY_MOUNTAINS, BiomeBank.SNOWY_MOUNTAINS), new OrePopulator(Material.LAPIS_ORE, TConfigOption.ORE_LAPIS_CHANCE.getInt(), TConfigOption.ORE_LAPIS_VEINSIZE.getInt(), TConfigOption.ORE_LAPIS_MAXVEINNUMBER.getInt(), TConfigOption.ORE_LAPIS_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_LAPIS_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_LAPIS_MAXSPAWNHEIGHT.getInt(), false, new BiomeBank[0]), new OrePopulator(Material.REDSTONE_ORE, TConfigOption.ORE_REDSTONE_CHANCE.getInt(), TConfigOption.ORE_REDSTONE_VEINSIZE.getInt(), TConfigOption.ORE_REDSTONE_MAXVEINNUMBER.getInt(), TConfigOption.ORE_REDSTONE_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_REDSTONE_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_REDSTONE_MAXSPAWNHEIGHT.getInt(), false, new BiomeBank[0]), new OrePopulator(Material.GRAVEL, TConfigOption.ORE_GRAVEL_CHANCE.getInt(), TConfigOption.ORE_GRAVEL_VEINSIZE.getInt(), TConfigOption.ORE_GRAVEL_MAXVEINNUMBER.getInt(), TConfigOption.ORE_GRAVEL_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_GRAVEL_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_GRAVEL_MAXSPAWNHEIGHT.getInt(), true, new BiomeBank[0]), new OrePopulator(Material.ANDESITE, TConfigOption.ORE_ANDESITE_CHANCE.getInt(), TConfigOption.ORE_ANDESITE_VEINSIZE.getInt(), TConfigOption.ORE_ANDESITE_MAXVEINNUMBER.getInt(), TConfigOption.ORE_ANDESITE_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_ANDESITE_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_ANDESITE_MAXSPAWNHEIGHT.getInt(), true, new BiomeBank[0]), new OrePopulator(Material.DIORITE, TConfigOption.ORE_DIORITE_CHANCE.getInt(), TConfigOption.ORE_DIORITE_VEINSIZE.getInt(), TConfigOption.ORE_DIORITE_MAXVEINNUMBER.getInt(), TConfigOption.ORE_DIORITE_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_DIORITE_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_DIORITE_MAXSPAWNHEIGHT.getInt(), true, new BiomeBank[0]), new OrePopulator(Material.GRANITE, TConfigOption.ORE_GRANITE_CHANCE.getInt(), TConfigOption.ORE_GRANITE_VEINSIZE.getInt(), TConfigOption.ORE_GRANITE_MAXVEINNUMBER.getInt(), TConfigOption.ORE_GRANITE_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_GRANITE_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_GRANITE_MAXSPAWNHEIGHT.getInt(), true, new BiomeBank[0])};
    private AmethystGeodePopulator amethystGeodePopulator;
    private MasterCavePopulatorDistributor caveDistributor = new MasterCavePopulatorDistributor();

    public TerraformPopulator(TerraformWorld tw) {
        if (Version.isAtLeast(17.0)) {
            this.amethystGeodePopulator = new AmethystGeodePopulator(TConfigOption.ORE_AMETHYST_GEODE_SIZE.getInt(), TConfigOption.ORE_AMETHYST_CHANCE.getDouble(), TConfigOption.ORE_AMETHYST_MIN_DEPTH.getInt(), TConfigOption.ORE_AMETHYST_MIN_DEPTH_BELOW_SURFACE.getInt());
            TerraformPopulator.ORE_POPS[0] = new OrePopulator(OneOneSevenBlockHandler.COPPER_ORE, TConfigOption.ORE_COPPER_CHANCE.getInt(), TConfigOption.ORE_COPPER_VEINSIZE.getInt(), TConfigOption.ORE_COPPER_MAXVEINNUMBER.getInt(), TConfigOption.ORE_COPPER_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_COPPER_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_COPPER_MAXSPAWNHEIGHT.getInt(), false, new BiomeBank[0]);
            TerraformPopulator.ORE_POPS[1] = new OrePopulator(OneOneSevenBlockHandler.DEEPSLATE, TConfigOption.ORE_DEEPSLATE_CHANCE.getInt(), TConfigOption.ORE_DEEPSLATE_VEINSIZE.getInt(), TConfigOption.ORE_DEEPSLATE_MAXVEINNUMBER.getInt(), TConfigOption.ORE_DEEPSLATE_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_DEEPSLATE_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_DEEPSLATE_MAXSPAWNHEIGHT.getInt(), true, new BiomeBank[0]);
            TerraformPopulator.ORE_POPS[2] = new OrePopulator(OneOneSevenBlockHandler.TUFF, TConfigOption.ORE_TUFF_CHANCE.getInt(), TConfigOption.ORE_TUFF_VEINSIZE.getInt(), TConfigOption.ORE_TUFF_MAXVEINNUMBER.getInt(), TConfigOption.ORE_TUFF_MINSPAWNHEIGHT.getInt(), TConfigOption.ORE_TUFF_COMMONSPAWNHEIGHT.getInt(), TConfigOption.ORE_TUFF_MAXSPAWNHEIGHT.getInt(), true, new BiomeBank[0]);
        }
        if (!Version.isAtLeast(18.0)) {
            boolean repairOreSettings = false;
            for (OrePopulator orePop : ORE_POPS) {
                if (orePop == null || orePop.getMinRange() > 0) continue;
                TerraformGeneratorPlugin.logger.stdout("&c" + orePop.getType().toString() + " was configured to use Y <= 0! Reverting ore configuration to hardcoded 1.16 values.");
                repairOreSettings = true;
            }
            if (repairOreSettings) {
                OrePopulatorFallbackSettings.repairOreSettings(ORE_POPS);
            }
        }
    }

    public void populate(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        random = tw.getHashedRand(571162L, data.getChunkX(), data.getChunkZ());
        for (OrePopulator orePopulator : ORE_POPS) {
            if (orePopulator == null) continue;
            orePopulator.populate(tw, random, data);
        }
        if (this.amethystGeodePopulator != null) {
            this.amethystGeodePopulator.populate(tw, random, data);
        }
        EnumSet<BiomeBank> banks = GenUtils.getBiomesInChunk(tw, data.getChunkX(), data.getChunkZ());
        boolean canDecorate = StructureBufferDistanceHandler.canDecorateChunk(tw, data.getChunkX(), data.getChunkZ());
        for (BiomeBank biomeBank : banks) {
            biomeBank.getHandler().populateSmallItems(tw, random, data);
            if (!canDecorate) continue;
            biomeBank.getHandler().populateLargeItems(tw, random, data);
        }
        this.caveDistributor.populate(tw, random, data);
        for (StructurePopulator structurePopulator : StructureRegistry.smallStructureRegistry) {
            if (!((MultiMegaChunkStructurePopulator)structurePopulator).canSpawn(tw, data.getChunkX(), data.getChunkZ())) continue;
            TerraformGeneratorPlugin.logger.info("Generating " + structurePopulator.getClass().getName() + " at chunk: " + data.getChunkX() + "," + data.getChunkZ());
            structurePopulator.populate(tw, data);
        }
    }
}

