/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.coregen;

import java.util.ArrayList;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeSection;
import org.terraform.coregen.ChunkCache;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public enum HeightMap {
    RIVER{

        @Override
        public double getHeight(TerraformWorld tw, int x, int z) {
            FastNoise noise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.HEIGHTMAP_RIVER, world -> {
                FastNoise n = new FastNoise((int)world.getSeed());
                n.SetNoiseType(FastNoise.NoiseType.PerlinFractal);
                n.SetFrequency(TConfigOption.HEIGHT_MAP_RIVER_FREQUENCY.getFloat());
                n.SetFractalOctaves(5);
                return n;
            });
            return 15.0f - 200.0f * Math.abs(noise.GetNoise(x, z));
        }
    }
    ,
    CORE{

        @Override
        public double getHeight(TerraformWorld tw, int x, int z) {
            FastNoise cubic = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.HEIGHTMAP_CORE, world -> {
                FastNoise n = new FastNoise((int)world.getSeed());
                n.SetNoiseType(FastNoise.NoiseType.CubicFractal);
                n.SetFractalOctaves(3);
                n.SetFrequency(TConfigOption.HEIGHT_MAP_CORE_FREQUENCY.getFloat());
                return n;
            });
            double height = cubic.GetNoise(x, z) * 2.0f * 5.0f + 7.0f + 62.0f;
            if (height > 72.0) {
                height = (height - 62.0 - 10.0) * 0.1 + 62.0 + 10.0;
            }
            if (height < 32.0) {
                height = -(32.0 - height) * 0.1 + 62.0 - 30.0;
            }
            return height;
        }
    }
    ,
    ATTRITION{

        @Override
        public double getHeight(TerraformWorld tw, int x, int z) {
            FastNoise perlin = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.HEIGHTMAP_ATTRITION, world -> {
                FastNoise n = new FastNoise((int)world.getSeed() + 113);
                n.SetNoiseType(FastNoise.NoiseType.PerlinFractal);
                n.SetFractalOctaves(4);
                n.SetFrequency(0.02f);
                return n;
            });
            double height = perlin.GetNoise(x, z) * 2.0f * 7.0f;
            return height < 0.0 ? 0.0 : height;
        }
    };

    public static final int defaultSeaLevel = 62;
    public static final float heightAmplifier;

    public static double getNoiseGradient(TerraformWorld tw, int x, int z, int radius) {
        double totalChangeInGradient = 0.0;
        int count = 0;
        double centerNoise = HeightMap.getBlockHeight(tw, x, z);
        for (int nx = -radius; nx <= radius; ++nx) {
            for (int nz = -radius; nz <= radius; ++nz) {
                if (nx == 0 && nz == 0) continue;
                totalChangeInGradient += Math.abs((double)HeightMap.getBlockHeight(tw, x + nx, z + nz) - centerNoise);
                ++count;
            }
        }
        return totalChangeInGradient / (double)count;
    }

    public static double getTrueHeightGradient(PopulatorDataAbstract data, int x, int z, int radius) {
        double totalChangeInGradient = 0.0;
        int count = 0;
        double centerNoise = GenUtils.getHighestGround(data, x, z);
        for (int nx = -radius; nx <= radius; ++nx) {
            for (int nz = -radius; nz <= radius; ++nz) {
                if (nx == 0 && nz == 0) continue;
                totalChangeInGradient += Math.abs((double)GenUtils.getHighestGround(data, x + nx, z + nz) - centerNoise);
                ++count;
            }
        }
        return totalChangeInGradient / (double)count;
    }

    public static double getRawRiverDepth(TerraformWorld tw, int x, int z) {
        double depth = RIVER.getHeight(tw, x, z);
        depth = depth < 0.0 ? 0.0 : depth;
        return depth;
    }

    public static double getPreciseHeight(TerraformWorld tw, int x, int z) {
        double depth;
        ChunkCache cache = TerraformGenerator.getCache(tw, x, z);
        double cachedValue = cache.getHeightMapHeight(x, z);
        if (cachedValue != 0.0) {
            return cachedValue;
        }
        double height = HeightMap.getRiverlessHeight(tw, x, z);
        if (height - (depth = HeightMap.getRawRiverDepth(tw, x, z)) >= (double)(TerraformGenerator.seaLevel - 15)) {
            height -= depth;
        } else if (height > (double)(TerraformGenerator.seaLevel - 15) && height - depth < (double)(TerraformGenerator.seaLevel - 15)) {
            height = TerraformGenerator.seaLevel - 15;
        }
        if (heightAmplifier != 1.0f && height > (double)TerraformGenerator.seaLevel) {
            height += (double)heightAmplifier * (height - (double)TerraformGenerator.seaLevel);
        }
        cache.cacheHeightMap(x, z, height);
        return height;
    }

    private static float getDominantBiomeHeight(TerraformWorld tw, int x, int z) {
        ChunkCache cache = TerraformGenerator.getCache(tw, x, z);
        float h2 = cache.getDominantBiomeHeight(x, z);
        if (h2 == Float.MIN_VALUE) {
            h2 = (float)BiomeBank.calculateHeightIndependentBiome(tw, x, z).getHandler().calculateHeight(tw, x, z);
        }
        cache.cacheDominantBiomeHeight(x, z, h2);
        return h2;
    }

    public static double getRiverlessHeight(TerraformWorld tw, int x, int z) {
        int maskRadius = 5;
        int maskDiameter = maskRadius * 2 + 1;
        double coreHeight = 0.0;
        ChunkCache mainCache = TerraformGenerator.getCache(tw, x, z);
        if (mainCache.getBlurredHeight(x, z) == (double)1.4E-45f) {
            float lineTotalHeight;
            ChunkCache targetCache;
            int relZ;
            int relX;
            BiomeSection sect = BiomeBank.getBiomeSectionFromBlockCoords(tw, x, z);
            ArrayList toPurgeValues = new ArrayList();
            for (relX = sect.getLowerBounds().getX(); relX <= sect.getUpperBounds().getX(); ++relX) {
                for (relZ = sect.getLowerBounds().getZ() - maskRadius; relZ <= sect.getUpperBounds().getZ() + maskRadius; ++relZ) {
                    targetCache = TerraformGenerator.getCache(tw, relX, relZ);
                    lineTotalHeight = 0.0f;
                    for (int offsetX = -maskRadius; offsetX <= maskRadius; ++offsetX) {
                        lineTotalHeight += HeightMap.getDominantBiomeHeight(tw, relX + offsetX, relZ);
                    }
                    if (targetCache.getIntermediateBlurHeight(relX, relZ) != (double)1.4E-45f) continue;
                    targetCache.cacheIntermediateBlurredHeight(relX, relZ, lineTotalHeight / (float)maskDiameter);
                }
            }
            for (relX = sect.getLowerBounds().getX(); relX <= sect.getUpperBounds().getX(); ++relX) {
                for (relZ = sect.getLowerBounds().getZ(); relZ <= sect.getUpperBounds().getZ(); ++relZ) {
                    targetCache = TerraformGenerator.getCache(tw, relX, relZ);
                    lineTotalHeight = 0.0f;
                    for (int offsetZ = -maskRadius; offsetZ <= maskRadius; ++offsetZ) {
                        ChunkCache queryCache = TerraformGenerator.getCache(tw, relX, relZ + offsetZ);
                        lineTotalHeight = (float)((double)lineTotalHeight + queryCache.getIntermediateBlurHeight(relX, relZ + offsetZ));
                    }
                    targetCache.cacheBlurredHeight(relX, relZ, lineTotalHeight / (float)maskDiameter);
                }
            }
        }
        coreHeight = mainCache.getBlurredHeight(x, z);
        return coreHeight += ATTRITION.getHeight(tw, x, z);
    }

    public static int getBlockHeight(TerraformWorld tw, int x, int z) {
        return (int)HeightMap.getPreciseHeight(tw, x, z);
    }

    public abstract double getHeight(TerraformWorld var1, int var2, int var3);

    static {
        heightAmplifier = TConfigOption.HEIGHT_MAP_LAND_HEIGHT_AMPLIFIER.getFloat();
    }
}

