/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.coregen;

import org.bukkit.Axis;
import org.terraform.biome.BiomeBank;
import org.terraform.data.TerraformWorld;

public class ChunkCache {
    public final TerraformWorld tw;
    public final int chunkX;
    public final int chunkZ;
    float[][] dominantBiomeHeightCache;
    float[][] blurredHeightCache;
    float[][] intermediateBlurCache;
    double[][] heightMapCache;
    short[][] highestGroundCache;
    BiomeBank[][] biomeCache;

    public ChunkCache(TerraformWorld tw, int chunkX, int chunkZ) {
        this.tw = tw;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.initInternalCache();
    }

    public ChunkCache(TerraformWorld tw, int rawX, int rawY, int rawZ) {
        this.tw = tw;
        this.chunkX = ChunkCache.getChunkCoordinate(rawX);
        this.chunkZ = ChunkCache.getChunkCoordinate(rawZ);
    }

    public static int getChunkCoordinate(int coordinate) {
        return coordinate >> 4;
    }

    public void initInternalCache() {
        this.highestGroundCache = new short[16][16];
        this.heightMapCache = new double[16][16];
        this.dominantBiomeHeightCache = new float[16][16];
        this.intermediateBlurCache = new float[16][16];
        this.blurredHeightCache = new float[16][16];
        for (int i = 0; i < 16; i = (int)((short)(i + 1))) {
            for (int j = 0; j < 16; j = (int)((short)(j + 1))) {
                this.highestGroundCache[i][j] = Short.MIN_VALUE;
                this.blurredHeightCache[i][j] = Float.MIN_VALUE;
                this.intermediateBlurCache[i][j] = Float.MIN_VALUE;
                this.dominantBiomeHeightCache[i][j] = Float.MIN_VALUE;
            }
        }
        this.biomeCache = new BiomeBank[16][16];
    }

    private int getCoordinateInsideChunk(int j, Axis ax) {
        return ax == Axis.X ? j - this.chunkX * 16 : j - this.chunkZ * 16;
    }

    public float getDominantBiomeHeight(int rawX, int rawZ) {
        return this.dominantBiomeHeightCache[this.getCoordinateInsideChunk(rawZ, Axis.Z)][this.getCoordinateInsideChunk(rawX, Axis.X)];
    }

    public void cacheDominantBiomeHeight(int rawX, int rawZ, float value) {
        this.dominantBiomeHeightCache[this.getCoordinateInsideChunk((int)rawZ, (Axis)Axis.Z)][this.getCoordinateInsideChunk((int)rawX, (Axis)Axis.X)] = value;
    }

    public double getHeightMapHeight(int rawX, int rawZ) {
        return this.heightMapCache[this.getCoordinateInsideChunk(rawZ, Axis.Z)][this.getCoordinateInsideChunk(rawX, Axis.X)];
    }

    public short getHighestGround(int rawX, int rawZ) {
        return this.highestGroundCache[this.getCoordinateInsideChunk(rawZ, Axis.Z)][this.getCoordinateInsideChunk(rawX, Axis.X)];
    }

    public void cacheHeightMap(int rawX, int rawZ, double value) {
        this.heightMapCache[this.getCoordinateInsideChunk((int)rawZ, (Axis)Axis.Z)][this.getCoordinateInsideChunk((int)rawX, (Axis)Axis.X)] = value;
    }

    public void cacheHighestGround(int rawX, int rawZ, short value) {
        this.highestGroundCache[this.getCoordinateInsideChunk((int)rawZ, (Axis)Axis.Z)][this.getCoordinateInsideChunk((int)rawX, (Axis)Axis.X)] = value;
    }

    public double getBlurredHeight(int rawX, int rawZ) {
        return this.blurredHeightCache[this.getCoordinateInsideChunk(rawZ, Axis.Z)][this.getCoordinateInsideChunk(rawX, Axis.X)];
    }

    public double getIntermediateBlurHeight(int rawX, int rawZ) {
        return this.intermediateBlurCache[this.getCoordinateInsideChunk(rawZ, Axis.Z)][this.getCoordinateInsideChunk(rawX, Axis.X)];
    }

    public void cacheBlurredHeight(int rawX, int rawZ, float value) {
        this.blurredHeightCache[this.getCoordinateInsideChunk((int)rawZ, (Axis)Axis.Z)][this.getCoordinateInsideChunk((int)rawX, (Axis)Axis.X)] = value;
    }

    public void cacheIntermediateBlurredHeight(int rawX, int rawZ, float value) {
        this.intermediateBlurCache[this.getCoordinateInsideChunk((int)rawZ, (Axis)Axis.Z)][this.getCoordinateInsideChunk((int)rawX, (Axis)Axis.X)] = value;
    }

    public BiomeBank getBiome(int rawX, int rawZ) {
        return this.biomeCache[this.getCoordinateInsideChunk(rawZ, Axis.Z)][this.getCoordinateInsideChunk(rawX, Axis.X)];
    }

    public BiomeBank cacheBiome(int rawX, int rawZ, BiomeBank value) {
        this.biomeCache[this.getCoordinateInsideChunk((int)rawZ, (Axis)Axis.Z)][this.getCoordinateInsideChunk((int)rawX, (Axis)Axis.X)] = value;
        return value;
    }

    public boolean areCoordsInside(int rawX, int rawZ) {
        return this.chunkX == rawX >> 4 && this.chunkZ == rawZ >> 4;
    }

    public int hashCode() {
        return this.tw.hashCode() ^ this.chunkX + this.chunkZ * 31;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChunkCache)) {
            return false;
        }
        ChunkCache chunk = (ChunkCache)obj;
        return this.tw == chunk.tw && this.chunkX == chunk.chunkX && this.chunkZ == chunk.chunkZ;
    }
}

