/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.command.contants;

import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.terraform.command.contants.TerraCommandArgument;
import org.terraform.tree.FractalTypes;

public class MushroomTypeArgument
extends TerraCommandArgument<FractalTypes.Mushroom> {
    public MushroomTypeArgument(String name, boolean isOptional) {
        super(name, isOptional);
    }

    @Override
    public FractalTypes.Mushroom parse(CommandSender sender, String value) {
        return FractalTypes.Mushroom.valueOf(value.toUpperCase());
    }

    @Override
    public String validate(CommandSender sender, String value) {
        try {
            this.parse(sender, value);
        }
        catch (IllegalArgumentException e) {
            return "Mushroom type does not exist!";
        }
        return "";
    }

    @Override
    public ArrayList<String> getTabOptions(String[] args) {
        if (args.length != 2) {
            return new ArrayList<String>();
        }
        ArrayList<String> values = new ArrayList<String>();
        for (FractalTypes.Mushroom type : FractalTypes.Mushroom.values()) {
            if (!type.toString().startsWith(args[1].toUpperCase())) continue;
            values.add(type.toString());
        }
        return values;
    }
}

