/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.command.contants;

import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.terraform.command.contants.TerraCommandArgument;
import org.terraform.tree.FractalTypes;

public class FractalTreeTypeArgument
extends TerraCommandArgument<FractalTypes.Tree> {
    public FractalTreeTypeArgument(String name, boolean isOptional) {
        super(name, isOptional);
    }

    @Override
    public FractalTypes.Tree parse(CommandSender sender, String value) {
        return FractalTypes.Tree.valueOf(value.toUpperCase());
    }

    @Override
    public String validate(CommandSender sender, String value) {
        try {
            this.parse(sender, value);
        }
        catch (IllegalArgumentException e) {
            return "Tree type does not exist!";
        }
        return "";
    }

    @Override
    public ArrayList<String> getTabOptions(String[] args) {
        if (args.length != 2) {
            return new ArrayList<String>();
        }
        ArrayList<String> values = new ArrayList<String>();
        for (FractalTypes.Tree type : FractalTypes.Tree.values()) {
            if (!type.toString().startsWith(args[1].toUpperCase())) continue;
            values.add(type.toString());
        }
        return values;
    }
}

