/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.command;

import java.util.Random;
import java.util.Stack;
import org.bukkit.command.CommandSender;
import org.terraform.command.contants.InvalidArgumentException;
import org.terraform.command.contants.TerraCommand;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class ValuesCommand
extends TerraCommand {
    public ValuesCommand(TerraformGeneratorPlugin plugin, String ... aliases) {
        super(plugin, aliases);
    }

    @Override
    public String getDefaultDescription() {
        return "Shows a range of values for stuff";
    }

    @Override
    public boolean canConsoleExec() {
        return true;
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.isOp();
    }

    private double warpSine(double tempUnwarpedSineX, int period, int seed) {
        double warp = GenUtils.randInt(new Random(3 * seed), -3, 3);
        if (warp == 0.0) {
            warp = 1.0;
        }
        if (warp < 0.0) {
            warp = (10.0 - 2.0 * warp) / 10.0;
        }
        double warpedValue = tempUnwarpedSineX == 0.0 && warp == 0.0 ? 0.0 : Math.pow(Math.abs(tempUnwarpedSineX), warp);
        if (tempUnwarpedSineX < 0.0) {
            warpedValue = -warpedValue;
        }
        return warpedValue;
    }

    @Override
    public void execute(CommandSender sender, Stack<String> args) throws InvalidArgumentException {
        MathValues vals = new MathValues();
        MathValues unwarped = new MathValues();
        MathValues warped = new MathValues();
        TerraformWorld tw = TerraformWorld.get("world-1232341234", new Random().nextInt(99999));
        FastNoise carverEntranceStandard = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.CARVER_STANDARD, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 111L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(4);
            n.SetFrequency(0.07f);
            return n;
        });
        int period = 4;
        int i = 0;
        while (i < 9000000) {
            int x = i++;
            int y = GenUtils.randInt(0, 100);
            int z = GenUtils.randInt(-10000, 10000);
            vals.addValue(carverEntranceStandard.GetNoise(x, y, z));
        }
        sender.sendMessage("Finished");
        sender.sendMessage("Highest: " + vals.getHighest());
        sender.sendMessage("Lowest: " + vals.getLowest());
        sender.sendMessage("Mean: " + vals.avg());
        sender.sendMessage("Warped: " + warped);
        sender.sendMessage("Unwarped" + unwarped);
    }

    private class MathValues {
        private double total = 0.0;
        private double lowest = 99999.0;
        private double highest = -99999.0;
        private int count = 0;

        public void addValue(double value) {
            this.total += value;
            ++this.count;
            if (value < this.lowest) {
                this.lowest = value;
            }
            if (value > this.highest) {
                this.highest = value;
            }
        }

        public double avg() {
            return this.total / (double)this.count;
        }

        public double getLowest() {
            return this.lowest;
        }

        public double getHighest() {
            return this.highest;
        }

        public String toString() {
            return this.getLowest() + " to " + this.getHighest() + ": " + this.avg();
        }
    }
}

