/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.command;

import java.util.Stack;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.terraform.command.contants.FractalTreeTypeArgument;
import org.terraform.command.contants.InvalidArgumentException;
import org.terraform.command.contants.TerraCommand;
import org.terraform.coregen.populatordata.PopulatorDataPostGen;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;

public class FractalTreeCommand
extends TerraCommand {
    public FractalTreeCommand(TerraformGeneratorPlugin plugin, String ... aliases) {
        super(plugin, aliases);
        this.parameters.add(new FractalTreeTypeArgument("type", false));
    }

    @Override
    public String getDefaultDescription() {
        return "Spawns a fractal tree";
    }

    @Override
    public boolean canConsoleExec() {
        return false;
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.isOp();
    }

    @Override
    public void execute(CommandSender sender, Stack<String> args) throws InvalidArgumentException {
        Player p = (Player)sender;
        PopulatorDataPostGen data = new PopulatorDataPostGen(p.getLocation().getChunk());
        TerraformWorld tw = TerraformWorld.get(p.getWorld());
        int x = p.getLocation().getBlockX();
        int y = p.getLocation().getBlockY();
        int z = p.getLocation().getBlockZ();
        try {
            new FractalTreeBuilder((FractalTypes.Tree)((Object)this.parseArguments(sender, args).get(0))).build(tw, data, x, y, z);
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(ChatColor.RED + "Invalid tree type.");
            sender.sendMessage(ChatColor.RED + "Valid types:");
            StringBuilder types = new StringBuilder();
            boolean b = true;
            for (FractalTypes.Tree type : FractalTypes.Tree.VALUES) {
                ChatColor col = ChatColor.RED;
                if (b) {
                    col = ChatColor.DARK_RED;
                }
                b = !b;
                types.append(col).append((Object)type).append(' ');
            }
            sender.sendMessage(types.toString());
        }
    }
}

