/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.command;

import java.util.Stack;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.terraform.command.contants.InvalidArgumentException;
import org.terraform.command.contants.TerraCommand;
import org.terraform.main.TerraformGeneratorPlugin;

public class BiomeVisualiserCommand
extends TerraCommand {
    public BiomeVisualiserCommand(TerraformGeneratorPlugin plugin, String ... aliases) {
        super(plugin, aliases);
    }

    @Override
    public String getDefaultDescription() {
        return "Displays a test for biome distribution with the current configuration options";
    }

    @Override
    public boolean canConsoleExec() {
        return false;
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.isOp();
    }

    @Override
    public void execute(CommandSender sender, Stack<String> args) throws InvalidArgumentException {
        Player p = (Player)sender;
        World world = Bukkit.getWorld((String)"world");
        for (int nx = -10; nx <= 10; ++nx) {
            for (int nz = -10; nz <= 10; ++nz) {
                for (int y = 0; y < 130; ++y) {
                    Location loc = new Location(world, p.getLocation().getX() + (double)nx, (double)y, p.getLocation().getZ() + (double)nz);
                    Biome b = world.getBiome(loc);
                    if (!b.toString().equals("PLAINS") || world.getType(loc).isSolid()) continue;
                    world.setType(loc, Material.RED_STAINED_GLASS);
                }
            }
        }
    }
}

