/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.command;

import java.util.HashMap;
import java.util.Random;
import java.util.Stack;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeClimate;
import org.terraform.biome.BiomeSection;
import org.terraform.biome.BiomeType;
import org.terraform.command.contants.InvalidArgumentException;
import org.terraform.command.contants.TerraCommand;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;

public class BiomeDistribCommand
extends TerraCommand {
    public BiomeDistribCommand(TerraformGeneratorPlugin plugin, String ... aliases) {
        super(plugin, aliases);
    }

    @Override
    public String getDefaultDescription() {
        return "Displays a test for biome distribution with the current configuration options";
    }

    @Override
    public boolean canConsoleExec() {
        return true;
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.isOp();
    }

    @Override
    public void execute(CommandSender sender, Stack<String> args) throws InvalidArgumentException {
        String percent;
        String count;
        int val;
        HashMap<BiomeBank, Integer> counts = new HashMap<BiomeBank, Integer>();
        HashMap<BiomeClimate, Integer> climates = new HashMap<BiomeClimate, Integer>();
        MathValues temperature = new MathValues();
        MathValues moisture = new MathValues();
        double numOceans = 0.0;
        double numMountains = 0.0;
        double total = 0.0;
        TerraformWorld tw = TerraformWorld.get("world-" + new Random().nextInt(99999), new Random().nextInt(99999));
        for (int nx = -50; nx < 50; ++nx) {
            for (int nz = -50; nz < 50; ++nz) {
                BiomeSection sect = BiomeBank.getBiomeSectionFromSectionCoords(tw, nx, nz, true);
                if (sect.getBiomeBank().getType() == BiomeType.OCEANIC || sect.getBiomeBank().getType() == BiomeType.DEEP_OCEANIC) {
                    numOceans += 1.0;
                }
                if (sect.getBiomeBank().getType() == BiomeType.MOUNTAINOUS || sect.getBiomeBank().getType() == BiomeType.HIGH_MOUNTAINOUS) {
                    numMountains += 1.0;
                }
                temperature.addValue(sect.getTemperature());
                moisture.addValue(sect.getMoisture());
                if (!counts.containsKey((Object)sect.getBiomeBank())) {
                    counts.put(sect.getBiomeBank(), 1);
                } else {
                    counts.put(sect.getBiomeBank(), (Integer)counts.get((Object)sect.getBiomeBank()) + 1);
                }
                if (!climates.containsKey((Object)sect.getBiomeBank().getClimate())) {
                    climates.put(sect.getBiomeBank().getClimate(), 1);
                    continue;
                }
                climates.put(sect.getBiomeBank().getClimate(), (Integer)climates.get((Object)sect.getBiomeBank().getClimate()) + 1);
            }
        }
        sender.sendMessage("Temperature: " + temperature.toString());
        sender.sendMessage("Moisture: " + moisture.toString());
        Object object = counts.values().iterator();
        while (object.hasNext()) {
            val = (Integer)object.next();
            total += (double)val;
        }
        for (BiomeBank b : BiomeBank.values()) {
            if (b.getType() == BiomeType.BEACH || b.getType() == BiomeType.RIVER) continue;
            count = "" + counts.getOrDefault((Object)b, 0);
            percent = "(" + Math.round((double)(100 * counts.getOrDefault((Object)b, 0)) / total);
            if (count.equals("0")) {
                count = ChatColor.RED + count;
            }
            if ((double)(100 * counts.getOrDefault((Object)b, 0)) / total < 5.0) {
                percent = ChatColor.RED + percent;
            }
            sender.sendMessage("%-35s(%-10s, %-10s): %-10s%s)".formatted(b.toString(), b.getClimate().getTemperatureRange(), b.getClimate().getMoistureRange(), count, percent + "%)"));
        }
        sender.sendMessage("=====================================");
        sender.sendMessage("Percent Ocean: " + 100.0 * numOceans / total + "%");
        sender.sendMessage("Percent Mountain: " + 100.0 * numMountains / total + "%");
        sender.sendMessage("===================================");
        total = 0.0;
        object = climates.values().iterator();
        while (object.hasNext()) {
            val = (Integer)object.next();
            total += (double)val;
        }
        for (BiomeClimate c2 : BiomeClimate.values()) {
            count = "" + climates.getOrDefault((Object)c2, 0);
            percent = "(" + Math.round((double)(100 * climates.getOrDefault((Object)c2, 0)) / total);
            if (count.equals("0")) {
                count = ChatColor.RED + count;
            }
            if ((double)(100 * climates.getOrDefault((Object)c2, 0)) / total < 5.0) {
                percent = ChatColor.RED + percent;
            }
            int biomeTypes = 0;
            for (BiomeBank b : BiomeBank.values()) {
                if (b.getClimate() != c2 || b.getType() != BiomeType.FLAT && b.getType() != BiomeType.MOUNTAINOUS && b.getType() != BiomeType.HIGH_MOUNTAINOUS) continue;
                ++biomeTypes;
            }
            float biomesPerPercent = (float)((double)biomeTypes / ((double)(100 * climates.getOrDefault((Object)c2, 0)) / total));
            sender.sendMessage("%-30s%-10s %-10s (%d registered biomes) (numBiomes/percent: %.2f)".formatted(c2.toString(), count, percent + "%)", biomeTypes, Float.valueOf(biomesPerPercent)));
        }
    }

    private class MathValues {
        private double total = 0.0;
        private double lowest = 99999.0;
        private double highest = -99999.0;
        private int count = 0;

        public void addValue(double value) {
            this.total += value;
            ++this.count;
            if (value < this.lowest) {
                this.lowest = value;
            }
            if (value > this.highest) {
                this.highest = value;
            }
        }

        public double avg() {
            return this.total / (double)this.count;
        }

        public double getLowest() {
            return this.lowest;
        }

        public double getHighest() {
            return this.highest;
        }

        public String toString() {
            return this.getLowest() + " to " + this.getHighest() + ": " + this.avg();
        }
    }
}

