/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.river;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class JungleRiverHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return true;
    }

    @Override
    public Biome getBiome() {
        return Biome.RIVER;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.DIRT, Material.DIRT, GenUtils.randMaterial(rand, Material.DIRT, Material.STONE, Material.DIRT), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        boolean growsKelp = random.nextBoolean();
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                if (y >= TerraformGenerator.seaLevel || data.getBiome(x, z) != this.getBiome()) continue;
                if (y >= TerraformGenerator.seaLevel - 2) {
                    data.setType(x, y, z, Material.SAND);
                } else if (y >= TerraformGenerator.seaLevel - 4 && random.nextBoolean()) {
                    data.setType(x, y, z, Material.SAND);
                }
                if (!BlockUtils.isStoneLike(data.getType(x, y, z))) continue;
                JungleRiverHandler.generateLilyPad(world, random, data, x, z, y);
                if (GenUtils.chance(random, 10, 100)) {
                    data.setType(x, y + 1, z, Material.SEAGRASS);
                    if (random.nextBoolean() && y < TerraformGenerator.seaLevel - 2) {
                        BlockUtils.setDoublePlant(data, x, y + 1, z, Material.TALL_SEAGRASS);
                    }
                } else if (GenUtils.chance(random, 3, 50) && growsKelp && y + 1 < TerraformGenerator.seaLevel - 10) {
                    JungleRiverHandler.generateKelp(x, y + 1, z, data, random);
                }
                if (!GenUtils.chance(random, TConfigOption.BIOME_CLAY_DEPOSIT_CHANCE_OUT_OF_THOUSAND.getInt(), 1000)) continue;
                BlockUtils.generateClayDeposit(x, y, z, data, random);
            }
        }
    }

    public static void generateLilyPad(TerraformWorld tw, Random random, PopulatorDataAbstract data, int x, int z, int highestGround) {
        if (GenUtils.chance(random, 1, (int)(JungleRiverHandler.getLilyPadNoise(tw, x, z) * 7.0 + Math.pow(TerraformGenerator.seaLevel - highestGround, 3.0) + 18.0))) {
            data.setType(x, TerraformGenerator.seaLevel + 1, z, Material.LILY_PAD);
        }
    }

    public static void generateKelp(int x, int y, int z, PopulatorDataAbstract data, Random random) {
        for (int ny = y; ny < TerraformGenerator.seaLevel - GenUtils.randInt(random, 0, 2); ++ny) {
            data.setType(x, ny, z, Material.KELP_PLANT);
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
    }

    public static double getLilyPadNoise(TerraformWorld tw, int x, int z) {
        FastNoise lilyPadNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_JUNGLE_LILYPADS, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 2L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFrequency(0.05f);
            return n;
        });
        return lilyPadNoise.GetNoise(x, z);
    }
}

