/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.ocean;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeType;
import org.terraform.biome.ocean.AbstractOceanHandler;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;

public class OceansHandler
extends AbstractOceanHandler {
    public OceansHandler(BiomeType oceanType) {
        super(oceanType);
    }

    @Override
    public boolean isOcean() {
        return true;
    }

    @Override
    public Biome getBiome() {
        if (this.oceanType == BiomeType.DEEP_OCEANIC) {
            return Biome.DEEP_OCEAN;
        }
        return Biome.OCEAN;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.GRAVEL, Material.GRAVEL, GenUtils.randMaterial(rand, Material.STONE, Material.GRAVEL, Material.STONE), GenUtils.randMaterial(rand, Material.STONE), GenUtils.randMaterial(rand, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        boolean growsKelp = random.nextBoolean();
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                if (data.getBiome(x, z) != this.getBiome()) continue;
                if (y >= TerraformGenerator.seaLevel - 2) {
                    data.setType(x, y, z, Material.SAND);
                } else if (y >= TerraformGenerator.seaLevel - 4 && random.nextBoolean()) {
                    data.setType(x, y, z, Material.SAND);
                }
                if (!BlockUtils.isStoneLike(data.getType(x, y, z))) continue;
                if (GenUtils.chance(random, 10, 100)) {
                    CoralGenerator.generateKelpGrowth(data, x, y + 1, z);
                    continue;
                }
                if (!GenUtils.chance(random, 3, 50) || !growsKelp || y + 1 >= TerraformGenerator.seaLevel - 10) continue;
                this.generateKelp(x, y + 1, z, data, random);
            }
        }
    }

    private void generateKelp(int x, int y, int z, PopulatorDataAbstract data, Random random) {
        for (int ny = y; ny < TerraformGenerator.seaLevel - GenUtils.randInt(5, 15); ++ny) {
            data.setType(x, ny, z, Material.KELP_PLANT);
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] rocks;
        for (SimpleLocation sLoc : rocks = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 25, 0.4f)) {
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome()) continue;
            int rockY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(rockY);
            if (data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.GRAVEL) continue;
            BlockUtils.replaceSphere(random.nextInt(9987), (float)GenUtils.randDouble(random, 3.0, 7.0), (float)GenUtils.randDouble(random, 2.0, 4.0), (float)GenUtils.randDouble(random, 3.0, 7.0), new SimpleBlock(data, sLoc), true, GenUtils.randMaterial(Material.STONE, Material.GRANITE, Material.ANDESITE, Material.DIORITE));
        }
    }
}

