/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.ocean;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeSection;
import org.terraform.biome.BiomeType;
import org.terraform.biome.ocean.AbstractOceanHandler;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class MushroomIslandHandler
extends AbstractOceanHandler {
    public MushroomIslandHandler() {
        super(BiomeType.DEEP_OCEANIC);
    }

    @Override
    public double calculateHeight(TerraformWorld tw, int x, int z) {
        double noise;
        double height = super.calculateHeight(tw, x, z);
        BiomeSection currentSection = BiomeBank.getBiomeSectionFromBlockCoords(tw, x, z);
        if (currentSection.getBiomeBank() != BiomeBank.MUSHROOM_ISLANDS) {
            currentSection = BiomeSection.getMostDominantSection(tw, x, z);
        }
        float islandRadius = (float)BiomeSection.sectionWidth / 2.5f;
        for (BlockFace face : BlockUtils.directBlockFaces) {
            if (!currentSection.getRelative(face.getModX(), face.getModZ()).getBiomeBank().getType().isDry()) continue;
            islandRadius *= 0.65f;
            break;
        }
        FastNoise circleNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_MUSHROOMISLAND_CIRCLE, world -> {
            FastNoise n = new FastNoise((int)world.getSeed());
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.04f);
            return n;
        });
        SimpleLocation center = currentSection.getCenter();
        int relX = x - center.getX();
        int relZ = z - center.getZ();
        double equationResult = Math.pow(relX, 2.0) / Math.pow(islandRadius, 2.0) + Math.pow(relZ, 2.0) / Math.pow(islandRadius, 2.0);
        if (equationResult <= (noise = 1.0 + 0.7 * (double)circleNoise.GetNoise(relX, relZ))) {
            double supplement = (double)TerraformGenerator.seaLevel - height;
            if (equationResult >= noise * 0.9) {
                return height + supplement * 0.6;
            }
            if (equationResult >= noise * 0.7) {
                return height + supplement + 10.0;
            }
            if (equationResult >= noise * 0.6) {
                return height + supplement + 9.0;
            }
            if (equationResult >= noise * 0.5) {
                return height + supplement + 8.0;
            }
            if (equationResult >= noise * 0.4) {
                return height + supplement + 7.5;
            }
            return height + supplement + 7.0;
        }
        return height;
    }

    @Override
    public boolean isOcean() {
        return true;
    }

    @Override
    public Biome getBiome() {
        return Biome.MUSHROOM_FIELDS;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.GRAVEL, Material.GRAVEL, GenUtils.randMaterial(rand, Material.STONE, Material.GRAVEL, Material.STONE), GenUtils.randMaterial(rand, Material.STONE), GenUtils.randMaterial(rand, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                if (data.getBiome(x, z) != this.getBiome() || y >= TerraformGenerator.seaLevel || !BlockUtils.isStoneLike(data.getType(x, y, z)) || !GenUtils.chance(random, 1, 150)) continue;
                CoralGenerator.generateKelpGrowth(data, x, y + 1, z);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] rocks;
        for (SimpleLocation sLoc : rocks = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 25, 0.4f)) {
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome()) continue;
            int rockY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(rockY);
            if (data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.GRAVEL || rockY >= TerraformGenerator.seaLevel) continue;
            BlockUtils.replaceSphere(random.nextInt(9987), (float)GenUtils.randDouble(random, 3.0, 7.0), (float)GenUtils.randDouble(random, 2.0, 4.0), (float)GenUtils.randDouble(random, 3.0, 7.0), new SimpleBlock(data, sLoc), true, GenUtils.randMaterial(Material.STONE, Material.GRANITE, Material.ANDESITE, Material.DIORITE));
        }
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.MUSHROOM_BEACH;
    }

    @Override
    public boolean forceDefaultToBeach() {
        return true;
    }
}

