/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.ocean;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeType;
import org.terraform.biome.ocean.AbstractOceanHandler;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class FrozenOceansHandler
extends AbstractOceanHandler {
    public FrozenOceansHandler(BiomeType oceanType) {
        super(oceanType);
    }

    @Override
    public boolean isOcean() {
        return true;
    }

    @Override
    public Biome getBiome() {
        if (this.oceanType == BiomeType.DEEP_OCEANIC) {
            return Biome.DEEP_FROZEN_OCEAN;
        }
        return Biome.FROZEN_OCEAN;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.GRAVEL, Material.GRAVEL, GenUtils.randMaterial(rand, Material.STONE, Material.GRAVEL, Material.STONE), GenUtils.randMaterial(rand, Material.STONE), GenUtils.randMaterial(rand, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                if (data.getBiome(x, z) != this.getBiome()) continue;
                if (y >= TerraformGenerator.seaLevel - 2) {
                    data.setType(x, y, z, Material.GRAVEL);
                } else if (y >= TerraformGenerator.seaLevel - 4 && random.nextBoolean()) {
                    data.setType(x, y, z, Material.GRAVEL);
                }
                if (data.getType(x, TerraformGenerator.seaLevel, z).isSolid()) continue;
                data.setType(x, TerraformGenerator.seaLevel, z, Material.ICE);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] rocks;
        for (SimpleLocation sLoc : rocks = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 25, 0.4f)) {
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome()) continue;
            int rockY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(rockY);
            if (data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.GRAVEL) continue;
            BlockUtils.replaceSphere(random.nextInt(9987), (float)GenUtils.randDouble(random, 3.0, 7.0), (float)GenUtils.randDouble(random, 2.0, 4.0), (float)GenUtils.randDouble(random, 3.0, 7.0), new SimpleBlock(data, sLoc), true, GenUtils.randMaterial(Material.STONE, Material.GRANITE, Material.ANDESITE, Material.DIORITE));
        }
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.ICY_BEACH;
    }
}

