/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.ocean;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeType;
import org.terraform.biome.ocean.AbstractOceanHandler;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.tree.TreeDB;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;

public class CoralReefOceanHandler
extends AbstractOceanHandler {
    public CoralReefOceanHandler(BiomeType oceanType) {
        super(oceanType);
    }

    @Override
    public boolean isOcean() {
        return true;
    }

    @Override
    public Biome getBiome() {
        if (this.oceanType == BiomeType.DEEP_OCEANIC) {
            return Biome.DEEP_LUKEWARM_OCEAN;
        }
        return Biome.LUKEWARM_OCEAN;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.GRAVEL, Material.GRAVEL, GenUtils.randMaterial(rand, Material.STONE, Material.GRAVEL, Material.STONE), GenUtils.randMaterial(rand, Material.STONE), GenUtils.randMaterial(rand, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                if (data.getBiome(x, z) != this.getBiome()) continue;
                if (y >= TerraformGenerator.seaLevel - 2) {
                    data.setType(x, y, z, Material.SAND);
                } else if (y >= TerraformGenerator.seaLevel - 4 && random.nextBoolean()) {
                    data.setType(x, y, z, Material.SAND);
                }
                if (!BlockUtils.isStoneLike(data.getType(x, y, z)) || !GenUtils.chance(random, 10, 100)) continue;
                CoralGenerator.generateKelpGrowth(data, x, y + 1, z);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] rocks;
        SimpleLocation[] smallCorals;
        SimpleLocation[] largeCorals;
        for (SimpleLocation sLoc : largeCorals = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 25, 0.4f)) {
            int coralY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(coralY);
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome()) continue;
            TreeDB.spawnRandomGiantCoral(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
            if (data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.GRAVEL) continue;
            BlockUtils.replaceCircularPatch(random.nextInt(9999), 4.0f, new SimpleBlock(data, sLoc), Material.SAND);
        }
        for (SimpleLocation sLoc : smallCorals = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 4, 0.5f)) {
            int coralY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(coralY);
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || data.getType(sLoc.getX(), sLoc.getY() + 1, sLoc.getZ()).isSolid()) continue;
            CoralGenerator.generateCoral(data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
            if (data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.GRAVEL) continue;
            BlockUtils.replaceCircularPatch(random.nextInt(9999), 2.0f, new SimpleBlock(data, sLoc), Material.SAND);
        }
        for (SimpleLocation sLoc : rocks = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 30, 0.4f)) {
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome()) continue;
            int rockY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(rockY);
            if (data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.GRAVEL) continue;
            BlockUtils.replaceSphere(random.nextInt(9987), (float)GenUtils.randDouble(random, 3.0, 7.0), (float)GenUtils.randDouble(random, 2.0, 4.0), (float)GenUtils.randDouble(random, 3.0, 7.0), new SimpleBlock(data, sLoc), true, GenUtils.randMaterial(Material.STONE, Material.GRANITE, Material.ANDESITE, Material.DIORITE));
        }
    }
}

