/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.mountainous;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.mountainous.AbstractMountainHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneEightBlockHandler;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class SnowyMountainsHandler
extends AbstractMountainHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return OneOneEightBlockHandler.SNOWY_SLOPES;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.STONE};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                double gradient;
                int y = GenUtils.getHighestGround(data, x, z);
                if (y < TerraformGenerator.seaLevel || data.getBiome(x, z) != this.getBiome()) continue;
                this.correctDirt(new SimpleBlock(data, x, y, z));
                data.setType(x, y + 1, z, Material.SNOW);
                if (GenUtils.chance(random, 1, 25)) {
                    Material stoneType = GenUtils.randMaterial(Material.ANDESITE, Material.DIORITE);
                    SnowyMountainsHandler.stoneStack(stoneType, data, random, x, y, z);
                    for (int nx = -2; nx <= 2; ++nx) {
                        for (int nz = -2; nz <= 2; ++nz) {
                            int stoneY;
                            if (GenUtils.chance(random, 1, 5) || (stoneY = GenUtils.getHighestGround(data, x + nx, z + nz)) < TerraformGenerator.seaLevel) continue;
                            SnowyMountainsHandler.stoneStack(stoneType, data, random, x + nx, stoneY, z + nz);
                        }
                    }
                }
                if (!((gradient = HeightMap.getTrueHeightGradient(data, x, z, 3)) < 1.4) || data.getBiome(x, z) != this.getBiome() || data.getBiome(x, z) != this.getBiome() || y < TerraformGenerator.seaLevel) continue;
                if (gradient < 1.2) {
                    data.setType(x, y, z, OneOneSevenBlockHandler.POWDER_SNOW);
                    data.setType(x, y + 1, z, Material.AIR);
                    continue;
                }
                data.setType(x, y, z, Material.SNOW_BLOCK);
            }
        }
    }

    private void correctDirt(SimpleBlock start) {
        for (int depth = 0; depth < 5; ++depth) {
            for (BlockFace face : BlockUtils.directBlockFaces) {
                if (start.getRelative(face).getType() != Material.STONE) continue;
                start.setType(Material.STONE);
                break;
            }
            start = start.getRelative(0, -1, 0);
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.ICY_BEACH;
    }

    @Override
    public BiomeBank getRiverType() {
        return BiomeBank.FROZEN_RIVER;
    }

    private static void stoneStack(Material stoneType, PopulatorDataAbstract data, Random rand, int x, int y, int z) {
        data.setType(x, y, z, stoneType);
        int depth = GenUtils.randInt(rand, 3, 7);
        for (int i = 1; i < depth && BlockUtils.isStoneLike(data.getType(x, y - i, z)); ++i) {
            data.setType(x, y - i, z, stoneType);
            if (!BlockUtils.isExposedToNonSolid(new SimpleBlock(data, x, y - i, z))) continue;
            ++depth;
        }
    }
}

