/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.mountainous;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeSection;
import org.terraform.biome.mountainous.AbstractMountainHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CylinderBuilder;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class ShatteredSavannaHandler
extends AbstractMountainHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.SAVANNA_PLATEAU;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.GRASS_BLOCK, Material.DIRT, GenUtils.randMaterial(Material.DIRT, Material.STONE), GenUtils.randMaterial(Material.DIRT, Material.STONE), Material.STONE};
    }

    @Override
    protected double getPeakMultiplier(BiomeSection section, Random sectionRandom) {
        double original = super.getPeakMultiplier(section, sectionRandom);
        return 1.0 + (original - 1.0) * 0.2;
    }

    @Override
    public double calculateHeight(TerraformWorld tw, int x, int z) {
        double height = super.calculateHeight(tw, x, z);
        FastNoise shatteredSavannaNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_SHATTERED_SAVANNANOISE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 2L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(6);
            n.SetFrequency(0.03f);
            return n;
        });
        double riverDepth = HeightMap.getRawRiverDepth(tw, x, z);
        if (height - riverDepth <= (double)(TerraformGenerator.seaLevel - 4)) {
            double makeup = 0.0;
            if (height - riverDepth > (double)(TerraformGenerator.seaLevel - 10)) {
                makeup = height - riverDepth - (double)(TerraformGenerator.seaLevel - 10);
            }
            height -= makeup;
        } else {
            double noise = shatteredSavannaNoise.GetNoise(x, z);
            if (noise > 0.0) {
                if (noise > 0.7) {
                    noise = 0.7;
                }
                height += 15.0;
            }
        }
        return height;
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                double gradient;
                int y = GenUtils.getHighestGround(data, x, z);
                if (y < TerraformGenerator.seaLevel || data.getBiome(x, z) != this.getBiome()) continue;
                if (y > TerraformGenerator.seaLevel + 20 && (gradient = HeightMap.getTrueHeightGradient(data, x, z, 3)) > 2.0 && GenUtils.chance(random, 1, 100)) {
                    float rY = (y - TerraformGenerator.seaLevel) / 3;
                    float radius = (float)Math.max(5.0, (double)(rY / 3.0f));
                    new CylinderBuilder(random, new SimpleBlock(data, x, y, z), Material.AIR).setRadius(radius).setRY(rY).setLowerType(Material.GRASS_BLOCK).setHardReplace(true).build();
                    y = GenUtils.getHighestGround(data, x, z);
                }
                if (data.getType(x, y, z) != Material.GRASS_BLOCK || data.getType(x, y + 1, z).isSolid() || !GenUtils.chance(random, 2, 10)) continue;
                data.setType(x, y + 1, z, Material.GRASS);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] poffs;
        SimpleLocation[] trees;
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 34)) {
            int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(treeY);
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            new FractalTreeBuilder(FractalTypes.Tree.SAVANNA_SMALL).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
        }
        for (SimpleLocation sLoc : poffs = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 35)) {
            int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(treeY);
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ())) || data.getType(sLoc.getX(), sLoc.getY() + 1, sLoc.getZ()).isSolid()) continue;
            SimpleBlock base = new SimpleBlock(data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
            int rX = GenUtils.randInt(random, 2, 4);
            int rY = GenUtils.randInt(random, 2, 4);
            int rZ = GenUtils.randInt(random, 2, 4);
            BlockUtils.replaceSphere(random.nextInt(999), (float)rX, (float)rY, (float)rZ, base, false, Material.ACACIA_LEAVES);
        }
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.SANDY_BEACH;
    }

    @Override
    public BiomeBank getRiverType() {
        return BiomeBank.RIVER;
    }
}

