/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.mountainous;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.mountainous.AbstractMountainHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.PhysicsUpdaterPopulator;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.version.OneOneEightBlockHandler;

public class RockyMountainsHandler
extends AbstractMountainHandler {
    private static void dirtStack(PopulatorDataAbstract data, Random rand, int x, int y, int z) {
        data.setType(x, y, z, Material.GRASS_BLOCK);
        if (GenUtils.chance(rand, 1, 10)) {
            data.setType(x, y + 1, z, Material.GRASS);
        }
        int depth = GenUtils.randInt(rand, 3, 7);
        for (int i = 1; i < depth && BlockUtils.isStoneLike(data.getType(x, y - i, z)); ++i) {
            data.setType(x, y - i, z, Material.DIRT);
            if (!BlockUtils.isExposedToNonSolid(new SimpleBlock(data, x, y - i, z))) continue;
            ++depth;
        }
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return OneOneEightBlockHandler.JAGGED_PEAKS;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{GenUtils.randMaterial(rand, Material.STONE, Material.STONE, Material.STONE, Material.STONE, Material.COBBLESTONE), GenUtils.randMaterial(rand, Material.COBBLESTONE, Material.STONE, Material.STONE), GenUtils.randMaterial(rand, Material.COBBLESTONE, Material.STONE, Material.STONE), GenUtils.randMaterial(rand, Material.COBBLESTONE, Material.STONE, Material.STONE), GenUtils.randMaterial(rand, Material.COBBLESTONE, Material.STONE, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        boolean spawnedWaterfall = false;
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                SimpleBlock block;
                int y = GenUtils.getHighestGround(data, x, z);
                if (y < TerraformGenerator.seaLevel) continue;
                if (GenUtils.chance(random, 1, 25)) {
                    RockyMountainsHandler.dirtStack(data, random, x, y, z);
                    for (int nx = -2; nx <= 2; ++nx) {
                        for (int nz = -2; nz <= 2; ++nz) {
                            if (GenUtils.chance(random, 1, 5) || (y = GenUtils.getHighestGround(data, x + nx, z + nz)) < TerraformGenerator.seaLevel) continue;
                            RockyMountainsHandler.dirtStack(data, random, x + nx, y, z + nz);
                        }
                    }
                }
                if (spawnedWaterfall || !(HeightMap.getTrueHeightGradient(data, x, z, 3) > 1.5) || !(HeightMap.CORE.getHeight(tw, x, z) - HeightMap.getRawRiverDepth(tw, x, z) < (double)TerraformGenerator.seaLevel) || !this.checkWaterfallSpace(block = new SimpleBlock(data, x, y, z)) || !GenUtils.chance(tw.getHashedRand(x, y, z), 1, 30)) continue;
                block = block.getRelative(0, -4, 0);
                RockyMountainsHandler.placeWaterFall(tw, x + 11 * z + 31 * y, block);
                spawnedWaterfall = true;
            }
        }
    }

    public static void placeWaterFall(TerraformWorld tw, int seed, SimpleBlock base) {
        float radius = 4.0f;
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.09f);
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float y = -radius / 2.0f; y <= radius / 2.0f; y += 1.0f) {
                for (float z = -radius; z <= radius; z += 1.0f) {
                    SimpleBlock rel = base.getRelative(Math.round(x), Math.round(y), Math.round(z));
                    double equationResult = Math.pow(x, 2.0) / Math.pow(radius, 2.0) + Math.pow(y, 2.0) / Math.pow(radius, 2.0) + Math.pow(z, 2.0) / Math.pow(radius, 2.0);
                    if (!(equationResult <= 1.0 + 0.7 * (double)noise.GetNoise(rel.getX(), rel.getY(), rel.getZ()))) continue;
                    if (y > 0.0f) {
                        rel.setType(Material.AIR);
                        continue;
                    }
                    if (!rel.getType().isSolid()) continue;
                    rel.setType(Material.WATER);
                    PhysicsUpdaterPopulator.pushChange(tw.getName(), new SimpleLocation(rel.getX(), rel.getY(), rel.getZ()));
                }
            }
        }
    }

    public boolean checkWaterfallSpace(SimpleBlock b) {
        if (b.getY() < TerraformGenerator.seaLevel + 15) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            if (b.getRelative(0, -i, 0).getType().isSolid()) continue;
            return false;
        }
        return BlockUtils.isExposedToNonSolid(b.getRelative(0, -4, 0));
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] trees;
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 14)) {
            if (!(HeightMap.getTrueHeightGradient(data, sLoc.getX(), sLoc.getZ(), 3) < 1.4)) continue;
            int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(treeY);
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            new FractalTreeBuilder(FractalTypes.Tree.NORMAL_SMALL).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
        }
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.ROCKY_BEACH;
    }
}

