/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.mountainous;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.flat.JungleHandler;
import org.terraform.biome.mountainous.AbstractMountainHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.tree.TreeDB;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CylinderBuilder;
import org.terraform.utils.GenUtils;
import org.terraform.utils.SphereBuilder;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class ForestedMountainsHandler
extends AbstractMountainHandler {
    private static void dirtStack(PopulatorDataAbstract data, Random rand, int x, int y, int z) {
        data.setType(x, y, z, Material.GRASS_BLOCK);
        if (GenUtils.chance(rand, 1, 10)) {
            data.setType(x, y + 1, z, Material.GRASS);
        }
        int depth = GenUtils.randInt(rand, 3, 7);
        for (int i = 1; i < depth && BlockUtils.isStoneLike(data.getType(x, y - i, z)); ++i) {
            data.setType(x, y - i, z, Material.DIRT);
            if (!BlockUtils.isExposedToNonSolid(new SimpleBlock(data, x, y - i, z))) continue;
            ++depth;
        }
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.JUNGLE;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{GenUtils.randMaterial(rand, Material.STONE, Material.STONE, Material.STONE, Material.STONE, Material.COBBLESTONE), GenUtils.randMaterial(rand, Material.COBBLESTONE, Material.STONE, Material.STONE), GenUtils.randMaterial(rand, Material.COBBLESTONE, Material.STONE, Material.STONE), GenUtils.randMaterial(rand, Material.COBBLESTONE, Material.STONE, Material.STONE), GenUtils.randMaterial(rand, Material.COBBLESTONE, Material.STONE, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                if (x % 3 == 0 && z % 3 == 0 && HeightMap.CORE.getHeight(tw, x, z) - HeightMap.getRawRiverDepth(tw, x, z) < (double)(TerraformGenerator.seaLevel - 4)) {
                    new SphereBuilder(random, new SimpleBlock(data, x, TerraformGenerator.seaLevel, z), Material.AIR).setRadius(5.0f).setStaticWaterLevel(TerraformGenerator.seaLevel).setHardReplace(true).build();
                    if (GenUtils.chance(random, 1, 30)) {
                        int cylY = TerraformGenerator.seaLevel + (y - TerraformGenerator.seaLevel) / 2 + 4;
                        new CylinderBuilder(random, new SimpleBlock(data, x, cylY, z), Material.AIR).setRadius(5.0f).setRY((y - TerraformGenerator.seaLevel) / 2 + 2).setHardReplace(true).build();
                    }
                }
                if (y < TerraformGenerator.seaLevel || !GenUtils.chance(random, 1, 25)) continue;
                ForestedMountainsHandler.dirtStack(data, random, x, y, z);
                for (int nx = -2; nx <= 2; ++nx) {
                    for (int nz = -2; nz <= 2; ++nz) {
                        if (GenUtils.chance(random, 1, 5) || (y = GenUtils.getHighestGround(data, x + nx, z + nz)) < TerraformGenerator.seaLevel) continue;
                        ForestedMountainsHandler.dirtStack(data, random, x + nx, y, z + nz);
                    }
                }
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] trees;
        FastNoise groundWoodNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_JUNGLE_GROUNDWOOD, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 12L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.07f);
            return n;
        });
        FastNoise groundLeavesNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_JUNGLE_GROUNDLEAVES, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 2L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFrequency(0.07f);
            return n;
        });
        SimpleLocation[] bigTrees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 20);
        if (TConfigOption.TREES_JUNGLE_BIG_ENABLED.getBoolean()) {
            for (SimpleLocation sLoc : bigTrees) {
                int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
                sLoc.setY(treeY);
                if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
                new FractalTreeBuilder(FractalTypes.Tree.JUNGLE_BIG).skipGradientCheck().build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
            }
        }
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 9)) {
            int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(treeY);
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            TreeDB.spawnSmallJungleTree(true, tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
        }
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                int distanceToSeaOrMountain = Math.min(y - TerraformGenerator.seaLevel, 80 - y);
                if (distanceToSeaOrMountain > 0) {
                    float leavesNoiseValue = groundLeavesNoise.GetNoise(x, z);
                    float groundWoodNoiseValue = groundWoodNoise.GetNoise(x, z);
                    if (distanceToSeaOrMountain <= 4) {
                        leavesNoiseValue -= -0.25f * (float)distanceToSeaOrMountain + 1.0f;
                        groundWoodNoiseValue -= -0.25f * (float)distanceToSeaOrMountain + 1.0f;
                    }
                    if ((double)leavesNoiseValue > -0.12 && Math.random() > 0.85) {
                        JungleHandler.createBush(data, leavesNoiseValue, x, y, z);
                    } else if (GenUtils.chance(random, 1, 10) && HeightMap.getTrueHeightGradient(data, x, z, 2) > 2.0) {
                        JungleHandler.createBush(data, 0.0f, x, y, z);
                    }
                    if ((double)groundWoodNoiseValue > 0.3) {
                        data.lsetType(x, y + 1, z, Material.JUNGLE_WOOD);
                    }
                }
                if (data.getBiome(x, z) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(x, y, z)) || data.getType(x, y + 1, z) != Material.JUNGLE_WOOD || !BlockUtils.isAir(data.getType(x, y + 2, z)) || !GenUtils.chance(2, 9)) continue;
                data.setType(x, y + 2, z, GenUtils.randMaterial(Material.RED_MUSHROOM, Material.BROWN_MUSHROOM));
            }
        }
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.SANDY_BEACH;
    }
}

