/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.mountainous;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeSection;
import org.terraform.biome.mountainous.AbstractMountainHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class DesertHillsHandler
extends AbstractMountainHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    protected double getPeakMultiplier(BiomeSection section, Random sectionRandom) {
        return GenUtils.randDouble(sectionRandom, 1.1, 1.3);
    }

    @Override
    public Biome getBiome() {
        return Biome.DESERT;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.SAND, Material.SAND, GenUtils.randMaterial(rand, Material.SANDSTONE, Material.SAND), GenUtils.randMaterial(rand, Material.SANDSTONE, Material.SAND), GenUtils.randMaterial(rand, Material.SANDSTONE, Material.SAND), Material.SANDSTONE, Material.SANDSTONE, Material.SANDSTONE, Material.SANDSTONE, Material.SANDSTONE, Material.SANDSTONE, GenUtils.randMaterial(rand, Material.SANDSTONE, Material.SAND, Material.STONE), GenUtils.randMaterial(rand, Material.SANDSTONE, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        FastNoise duneNoise = NoiseCacheHandler.getNoise(world, NoiseCacheHandler.NoiseCacheEntry.BIOME_DESERT_DUNENOISE, tw -> {
            FastNoise n = new FastNoise((int)tw.getSeed());
            n.SetNoiseType(FastNoise.NoiseType.CubicFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.03f);
            return n;
        });
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int highest;
                int y = highest = GenUtils.getTrueHighestBlock(data, x, z);
                while ((double)y > HeightMap.CORE.getHeight(world, x, z)) {
                    if (data.getBiome(x, z) == this.getBiome() && duneNoise.GetNoise(x, y, z) > 0.0f) {
                        if (data.getType(x, y, z).toString().endsWith("SAND")) {
                            if (TConfigOption.BIOME_DESERT_MOUNTAINS_YELLOW_CONCRETE_POWDER.getBoolean()) {
                                data.setType(x, y, z, Material.YELLOW_CONCRETE_POWDER);
                            }
                        } else if (data.getType(x, y, z).toString().endsWith("SANDSTONE") && TConfigOption.BIOME_DESERT_MOUNTAINS_YELLOW_CONCRETE.getBoolean()) {
                            data.setType(x, y, z, Material.YELLOW_CONCRETE);
                        }
                    }
                    --y;
                }
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
    }
}

