/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.mountainous;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeSection;
import org.terraform.biome.BiomeType;
import org.terraform.biome.mountainous.AbstractMountainHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneEightBlockHandler;

public class BirchMountainsHandler
extends AbstractMountainHandler {
    @Override
    protected double getPeakMultiplier(BiomeSection section, Random sectionRandom) {
        return GenUtils.randDouble(sectionRandom, 1.1, 1.3);
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return OneOneEightBlockHandler.JAGGED_PEAKS;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.GRASS_BLOCK, Material.DIRT, Material.DIRT, GenUtils.randMaterial(rand, Material.DIRT, Material.STONE), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                if (data.getBiome(x, z) != this.getBiome()) continue;
                this.setRock(new SimpleBlock(data, x, 0, z).getGround());
                if (data.getType(x, y, z) != Material.GRASS_BLOCK || !GenUtils.chance(random, 1, 10)) continue;
                data.setType(x, y + 1, z, Material.GRASS);
                if (random.nextBoolean()) {
                    BlockUtils.setDoublePlant(data, x, y + 1, z, Material.TALL_GRASS);
                    continue;
                }
                data.setType(x, y + 1, z, BlockUtils.pickFlower());
            }
        }
    }

    private void setRock(SimpleBlock target) {
        if (HeightMap.getTrueHeightGradient(target.getPopData(), target.getX(), target.getZ(), 3) > TConfigOption.MISC_TREES_GRADIENT_LIMIT.getDouble()) {
            Material rock = Material.ANDESITE;
            if (HeightMap.getTrueHeightGradient(target.getPopData(), target.getX(), target.getZ(), 3) > TConfigOption.MISC_TREES_GRADIENT_LIMIT.getDouble() * 2.0) {
                rock = Material.DIORITE;
            }
            while (BlockUtils.isExposedToNonSolid(target)) {
                target.setType(rock);
                target = target.getRelative(0, -1, 0);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] trees;
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 7)) {
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome()) continue;
            int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(treeY);
            if (TConfigOption.TREES_BIRCH_BIG_ENABLED.getBoolean() && GenUtils.chance(random, 1, 20)) {
                new FractalTreeBuilder(FractalTypes.Tree.BIRCH_BIG).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
                continue;
            }
            new FractalTreeBuilder(FractalTypes.Tree.BIRCH_SMALL).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
        }
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.ROCKY_BEACH;
    }

    @Override
    public double calculateHeight(TerraformWorld tw, int x, int z) {
        double riverDepth;
        SimpleLocation mountainPeak;
        double distFromPeak;
        Random sectionRand;
        double maxPeak;
        double heightMultiplier;
        double height = HeightMap.CORE.getHeight(tw, x, z);
        double maxMountainRadius = BiomeSection.sectionWidth;
        double coreRawHeight = height += HeightMap.ATTRITION.getHeight(tw, x, z);
        BiomeSection sect = BiomeBank.getBiomeSectionFromBlockCoords(tw, x, z);
        if (sect.getBiomeBank().getType() != BiomeType.MOUNTAINOUS) {
            sect = BiomeSection.getMostDominantSection(tw, x, z);
        }
        if ((heightMultiplier = (maxPeak = this.getPeakMultiplier(sect, sectionRand = sect.getSectionRandom())) * ((distFromPeak = 1.42 * maxMountainRadius - Math.sqrt(Math.pow(x - (mountainPeak = sect.getCenter()).getX(), 2.0) + Math.pow(z - mountainPeak.getZ(), 2.0))) / maxMountainRadius)) < 1.0) {
            heightMultiplier = 1.0;
        }
        if ((height *= heightMultiplier) > 200.0) {
            height = 200.0 + (height - 200.0) * 0.5;
        }
        if (height > 230.0) {
            height = 230.0 + (height - 230.0) * 0.3;
        }
        if (height > 240.0) {
            height = 240.0 + (height - 240.0) * 0.1;
        }
        if (height > 250.0) {
            height = 250.0 + (height - 250.0) * 0.05;
        }
        if (coreRawHeight - (riverDepth = HeightMap.getRawRiverDepth(tw, x, z)) <= (double)(TerraformGenerator.seaLevel - 4)) {
            double makeup = 0.0;
            if (coreRawHeight - riverDepth > (double)(TerraformGenerator.seaLevel - 10)) {
                makeup = coreRawHeight - riverDepth - (double)(TerraformGenerator.seaLevel - 10);
            }
            height = coreRawHeight - makeup;
        }
        return height;
    }
}

