/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.mountainous;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeSection;
import org.terraform.biome.mountainous.AbstractMountainHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.OneOneEightBlockHandler;

public class BadlandsCanyonHandler
extends AbstractMountainHandler {
    public static void oneUnit(TerraformWorld world, Random random, PopulatorDataAbstract data, int x, int z, boolean force) {
        int highest = GenUtils.getTrueHighestBlock(data, x, z);
        int threshold = 65;
        if (force) {
            threshold = highest - GenUtils.randInt(random, 3, 6);
        }
        for (int y = highest; y > threshold; --y) {
            if (data.getBiome(x, z) != OneOneEightBlockHandler.ERODED_BADLANDS && !force && data.getBiome(x, z) == Biome.DESERT || data.getType(x, y, z) != Material.RED_SANDSTONE && data.getType(x, y, z) != Material.SANDSTONE && data.getType(x, y, z) != Material.RED_SAND && data.getType(x, y, z) != Material.SAND && data.getType(x, y, z) != Material.STONE) continue;
            data.setType(x, y, z, BlockUtils.getTerracotta(y));
        }
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return OneOneEightBlockHandler.ERODED_BADLANDS;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.RED_SAND, Material.RED_SAND, Material.RED_SAND, Material.RED_SAND, Material.RED_SAND, Material.RED_SAND, GenUtils.randMaterial(rand, Material.RED_SANDSTONE, Material.RED_SAND), GenUtils.randMaterial(rand, Material.RED_SANDSTONE, Material.RED_SAND), Material.RED_SANDSTONE, Material.RED_SANDSTONE, Material.RED_SANDSTONE, Material.RED_SANDSTONE, Material.RED_SANDSTONE, Material.RED_SANDSTONE, Material.RED_SANDSTONE, Material.RED_SANDSTONE, Material.RED_SANDSTONE, Material.RED_SANDSTONE, Material.RED_SANDSTONE, GenUtils.randMaterial(rand, Material.RED_SANDSTONE, Material.STONE), GenUtils.randMaterial(rand, Material.RED_SANDSTONE, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                if (data.getBiome(x, z) != this.getBiome()) continue;
                if ((double)y > 10.0 + HeightMap.CORE.getHeight(world, x, z)) {
                    BadlandsCanyonHandler.oneUnit(world, random, data, x, z, false);
                }
                if (!(HeightMap.getTrueHeightGradient(data, x, z, 2) < 2.0)) continue;
                data.setType(x, y, z, Material.RED_SAND);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.BADLANDS_BEACH;
    }

    @Override
    public double calculateHeight(TerraformWorld tw, int x, int z) {
        double minMultiplier;
        SimpleLocation mountainPeak;
        double angleFromPeak;
        double circleFuzz;
        double distFromPeak;
        Random sectionRand;
        double maxPeak;
        double heightMultiplier;
        double baseHeight = HeightMap.CORE.getHeight(tw, x, z);
        FastNoise duneNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_BADLANDS_CANYON_NOISE, world -> {
            FastNoise n = new FastNoise((int)world.getSeed());
            n.SetNoiseType(FastNoise.NoiseType.Simplex);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.02f);
            return n;
        });
        double noise = duneNoise.GetNoise(x, z);
        if (noise < 0.0) {
            noise = 0.0;
        }
        double height = HeightMap.CORE.getHeight(tw, x, z);
        double maxMountainRadius = BiomeSection.sectionWidth;
        height += noise * 20.0;
        BiomeSection sect = BiomeBank.getBiomeSectionFromBlockCoords(tw, x, z);
        if (sect.getBiomeBank() != BiomeBank.BADLANDS_CANYON || sect.getBiomeBank() != BiomeBank.BADLANDS_CANYON_PEAK) {
            sect = BiomeSection.getMostDominantSection(tw, x, z);
        }
        if ((heightMultiplier = (maxPeak = this.getPeakMultiplier(sect, sectionRand = sect.getSectionRandom())) * ((distFromPeak = (circleFuzz = 1.32 + (double)Math.abs(duneNoise.GetValue((float)(10.0 * (angleFromPeak = (double)new SimpleLocation(x, 0, z).twoDAngleTo(mountainPeak = sect.getCenter()))), 40519 * mountainPeak.getX() + 75721 * mountainPeak.getZ()))) * maxMountainRadius - Math.sqrt(Math.pow(x - mountainPeak.getX(), 2.0) + Math.pow(z - mountainPeak.getZ(), 2.0))) / maxMountainRadius)) < (minMultiplier = 1.0)) {
            heightMultiplier = minMultiplier;
        }
        if ((height *= heightMultiplier) > 75.0) {
            if (height < 80.0) {
                height = 80.0;
            }
            height = height < 90.0 ? 90.0 : (height < 105.0 ? 105.0 : (height < 120.0 ? 120.0 : 135.0));
        } else {
            height = baseHeight;
        }
        return height;
    }

    @Override
    protected double getPeakMultiplier(BiomeSection section, Random sectionRandom) {
        return super.getPeakMultiplier(section, sectionRandom) * 0.9;
    }
}

