/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.mountainous;

import java.util.Random;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.biome.BiomeSection;
import org.terraform.biome.BiomeSubSection;
import org.terraform.biome.BiomeType;
import org.terraform.coregen.HeightMap;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.main.config.TConfigOption;
import org.terraform.utils.GenUtils;

public abstract class AbstractMountainHandler
extends BiomeHandler {
    protected double getPeakMultiplier(BiomeSection section, Random sectionRandom) {
        double lowerBound = 1.4;
        double upperBound = 1.7;
        float mt = TConfigOption.BIOME_MOUNTAINOUS_THRESHOLD.getFloat();
        for (int[] rel : new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}}) {
            int nx = rel[0];
            int nz = rel[1];
            if (!(section.getRelative(nx, nz).getOceanLevel() >= (double)mt)) continue;
            lowerBound = 1.2;
            upperBound = 1.4;
            break;
        }
        return GenUtils.randDouble(sectionRandom, lowerBound, upperBound);
    }

    @Override
    public double calculateHeight(TerraformWorld tw, int x, int z) {
        double height = HeightMap.CORE.getHeight(tw, x, z);
        double maxMountainRadius = BiomeSection.sectionWidth;
        height += HeightMap.ATTRITION.getHeight(tw, x, z);
        BiomeSection sect = BiomeBank.getBiomeSectionFromBlockCoords(tw, x, z);
        if (sect.getBiomeBank().getType() != BiomeType.MOUNTAINOUS) {
            sect = BiomeSection.getMostDominantSection(tw, x, z);
        }
        Random sectionRand = sect.getSectionRandom();
        double maxPeak = this.getPeakMultiplier(sect, sectionRand);
        SimpleLocation mountainPeak = sect.getCenter();
        double distFromPeak = 1.42 * maxMountainRadius - Math.sqrt(Math.pow(x - mountainPeak.getX(), 2.0) + Math.pow(z - mountainPeak.getZ(), 2.0));
        double heightMultiplier = maxPeak * (distFromPeak / maxMountainRadius);
        double minMultiplier = 1.0;
        BiomeSubSection subSect = sect.getSubSection(x, z);
        float mt = TConfigOption.BIOME_MOUNTAINOUS_THRESHOLD.getFloat();
        switch (subSect) {
            case NEGATIVE_X: {
                if (!(sect.getRelative(-1, 0).getOceanLevel() >= (double)mt)) break;
                minMultiplier = 1.25;
                break;
            }
            case NEGATIVE_Z: {
                if (!(sect.getRelative(0, -1).getOceanLevel() >= (double)mt)) break;
                minMultiplier = 1.25;
                break;
            }
            case POSITIVE_X: {
                if (!(sect.getRelative(1, 0).getOceanLevel() >= (double)mt)) break;
                minMultiplier = 1.25;
                break;
            }
            case POSITIVE_Z: {
                if (!(sect.getRelative(1, 0).getOceanLevel() >= (double)mt)) break;
                minMultiplier = 1.25;
                break;
            }
            case NONE: {
                minMultiplier = 1.7;
            }
        }
        if (heightMultiplier < minMultiplier) {
            heightMultiplier = minMultiplier;
        }
        if ((height *= heightMultiplier) > (double)(TerraformGeneratorPlugin.injector.getMaxY() - 56)) {
            height = (double)(TerraformGeneratorPlugin.injector.getMaxY() - 56) + (height - (double)(TerraformGeneratorPlugin.injector.getMaxY() - 56)) * 0.5;
        }
        if (height > (double)(TerraformGeneratorPlugin.injector.getMaxY() - 25)) {
            height = (double)(TerraformGeneratorPlugin.injector.getMaxY() - 25) + (height - (double)(TerraformGeneratorPlugin.injector.getMaxY() - 25)) * 0.3;
        }
        if (height > (double)(TerraformGeneratorPlugin.injector.getMaxY() - 15)) {
            height = (double)(TerraformGeneratorPlugin.injector.getMaxY() - 15) + (height - (double)(TerraformGeneratorPlugin.injector.getMaxY() - 15)) * 0.1;
        }
        if (height > (double)(TerraformGeneratorPlugin.injector.getMaxY() - 5)) {
            height = (double)(TerraformGeneratorPlugin.injector.getMaxY() - 5) + (height - (double)(TerraformGeneratorPlugin.injector.getMaxY() - 5)) * 0.05;
        }
        return height;
    }
}

