/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class TaigaHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.TAIGA;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.GRASS_BLOCK, Material.DIRT, Material.DIRT, GenUtils.randMaterial(rand, Material.DIRT, Material.STONE), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        FastNoise sweetBerriesNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_TAIGA_BERRY_BUSHNOISE, w -> {
            FastNoise n = new FastNoise((int)(w.getSeed() * 2L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFrequency(0.04f);
            return n;
        });
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getTrueHighestBlock(data, x, z);
                if (data.getBiome(x, z) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(x, y, z))) continue;
                if ((double)sweetBerriesNoise.GetNoise(x, z) > 0.3 && (double)(sweetBerriesNoise.GetNoise(x, z) * random.nextFloat()) > 0.35) {
                    Ageable bush = (Ageable)Material.SWEET_BERRY_BUSH.createBlockData();
                    bush.setAge(GenUtils.randInt(random, 1, 3));
                    data.setBlockData(x, y + 1, z, (BlockData)bush);
                    continue;
                }
                if (!GenUtils.chance(random, 1, 16)) continue;
                int i = random.nextInt(4);
                if (i >= 2) {
                    BlockUtils.setDoublePlant(data, x, y + 1, z, random.nextBoolean() ? Material.TALL_GRASS : Material.LARGE_FERN);
                    continue;
                }
                if (i == 1) {
                    data.setType(x, y + 1, z, random.nextBoolean() ? Material.GRASS : Material.FERN);
                    continue;
                }
                data.setType(x, y + 1, z, BlockUtils.pickFlower());
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] trees;
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 11)) {
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome()) continue;
            int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(treeY);
            if (TConfigOption.TREES_TAIGA_BIG_ENABLED.getBoolean() && GenUtils.chance(random, 1, 20)) {
                if (!new FractalTreeBuilder(FractalTypes.Tree.TAIGA_BIG).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ())) continue;
                TaigaHandler.replacePodzol(tw.getHashedRand(sLoc.getX(), sLoc.getY(), sLoc.getZ()).nextInt(9999), 5.0f, new SimpleBlock(data, sLoc.getX(), sLoc.getY() - 1, sLoc.getZ()));
                continue;
            }
            if (!new FractalTreeBuilder(FractalTypes.Tree.TAIGA_SMALL).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ())) continue;
            TaigaHandler.replacePodzol(tw.getHashedRand(sLoc.getX(), sLoc.getY(), sLoc.getZ()).nextInt(9999), 3.5f, new SimpleBlock(data, sLoc.getX(), sLoc.getY() - 1, sLoc.getZ()));
        }
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.ROCKY_BEACH;
    }

    public static void replacePodzol(int seed, float radius, SimpleBlock base) {
        if (radius <= 0.0f) {
            return;
        }
        if ((double)radius <= 0.5) {
            base.setType(GenUtils.randMaterial(new Random(seed), Material.PODZOL));
            return;
        }
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.13f);
        Random rand = new Random(seed);
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float z = -radius; z <= radius; z += 1.0f) {
                double noiseVal;
                double equationResult;
                SimpleBlock rel = base.getRelative(Math.round(x), 0, Math.round(z));
                if (!BlockUtils.isDirtLike((rel = rel.getGround()).getType()) || !((equationResult = Math.pow(x, 2.0) / Math.pow(radius, 2.0) + Math.pow(z, 2.0) / Math.pow(radius, 2.0)) <= 1.0 + (noiseVal = (double)Math.abs(noise.GetNoise(rel.getX(), rel.getZ()))))) continue;
                if (equationResult * 4.0 > 0.7 + noiseVal) {
                    if (!rand.nextBoolean()) continue;
                    rel.setType(Material.PODZOL);
                    continue;
                }
                rel.setType(Material.PODZOL);
            }
        }
    }
}

