/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Snowable;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;

public class SnowyTaigaHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.SNOWY_TAIGA;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{GenUtils.weightedRandomMaterial(rand, Material.GRASS_BLOCK, 35, Material.DIRT, 3, Material.PODZOL, 2), Material.DIRT, Material.DIRT, GenUtils.randMaterial(rand, Material.DIRT, Material.STONE), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                if (data.getBiome(x, z) != this.getBiome()) continue;
                if (data.getType(x, y, z) == Material.DIRT && GenUtils.chance(random, 1, 20)) {
                    data.setType(x, y + 1, z, Material.DEAD_BUSH);
                    if (random.nextBoolean()) {
                        data.setType(x, y + 1, z, Material.ALLIUM);
                    }
                }
                if (data.getType(x, y + 1, z) != Material.AIR || !GenUtils.isGroundLike(data.getType(x, y, z))) continue;
                data.setType(x, y + 1, z, Material.SNOW);
                if (!(data.getBlockData(x, y, z) instanceof Snowable)) continue;
                Snowable snowable = (Snowable)data.getBlockData(x, y, z);
                snowable.setSnowy(true);
                data.setBlockData(x, y, z, (BlockData)snowable);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] trees;
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 11)) {
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome()) continue;
            int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(treeY);
            if (TConfigOption.TREES_TAIGA_BIG_ENABLED.getBoolean() && GenUtils.chance(random, 1, 20)) {
                new FractalTreeBuilder(FractalTypes.Tree.TAIGA_BIG).setSnowyLeaves(true).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
                SnowyTaigaHandler.defrostAndReplacePodzol(tw.getHashedRand(sLoc.getX(), sLoc.getY(), sLoc.getZ()).nextInt(9999), 2.5f, new SimpleBlock(data, sLoc.getX(), sLoc.getY() - 1, sLoc.getZ()));
                continue;
            }
            new FractalTreeBuilder(FractalTypes.Tree.TAIGA_SMALL).setSnowyLeaves(true).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
            SnowyTaigaHandler.defrostAndReplacePodzol(tw.getHashedRand(sLoc.getX(), sLoc.getY(), sLoc.getZ()).nextInt(9999), 1.5f, new SimpleBlock(data, sLoc.getX(), sLoc.getY() - 1, sLoc.getZ()));
        }
    }

    public static void defrostAndReplacePodzol(int seed, float radius, SimpleBlock base) {
        if (radius <= 0.0f) {
            return;
        }
        if ((double)radius <= 0.5) {
            base.setType(GenUtils.randMaterial(new Random(seed), Material.PODZOL));
            return;
        }
        FastNoise noise = new FastNoise(seed);
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
        noise.SetFrequency(0.13f);
        Random rand = new Random(seed);
        for (float x = -radius; x <= radius; x += 1.0f) {
            for (float z = -radius; z <= radius; z += 1.0f) {
                double noiseVal;
                double equationResult;
                SimpleBlock rel = base.getRelative(Math.round(x), 0, Math.round(z));
                if (!BlockUtils.isDirtLike((rel = rel.getGround()).getType()) || !((equationResult = Math.pow(x, 2.0) / Math.pow(radius, 2.0) + Math.pow(z, 2.0) / Math.pow(radius, 2.0)) <= 1.0 + (noiseVal = (double)Math.abs(noise.GetNoise(rel.getX(), rel.getZ()))))) continue;
                if (equationResult * 4.0 > 0.7 + noiseVal) {
                    if (!rand.nextBoolean()) continue;
                    rel.setType(Material.PODZOL);
                    rel.getRelative(0, 1, 0).lsetType(Material.AIR);
                    continue;
                }
                rel.setType(Material.PODZOL);
                rel.getRelative(0, 1, 0).lsetType(Material.AIR);
            }
        }
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.ICY_BEACH;
    }

    @Override
    public BiomeBank getRiverType() {
        return BiomeBank.FROZEN_RIVER;
    }
}

