/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class SavannaHandler
extends BiomeHandler {
    private static void makeYellowPatch(int x, int y, int z, PopulatorDataAbstract data, Random random) {
        int length = GenUtils.randInt(6, 16);
        int nx = x;
        int nz = z;
        while (length-- > 0) {
            if (BlockUtils.isDirtLike(data.getType(nx, y, nz)) && data.getType(nx, y + 1, nz) == Material.AIR) {
                data.setType(nx, y, nz, OneOneSevenBlockHandler.DIRT_PATH());
            }
            switch (random.nextInt(5)) {
                case 0: {
                    ++nx;
                    break;
                }
                case 2: {
                    ++nz;
                    break;
                }
                case 3: {
                    --nx;
                    break;
                }
                case 4: {
                    --nz;
                }
            }
            y = GenUtils.getTrueHighestBlock(data, nx, nz);
        }
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.SAVANNA;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{GenUtils.randMaterial(rand, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.GRASS_BLOCK, Material.COARSE_DIRT), Material.DIRT, Material.DIRT, GenUtils.randMaterial(rand, Material.DIRT, Material.STONE), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        for (int i = 0; i < GenUtils.randInt(random, 1, 3); ++i) {
            int x = data.getChunkX() * 16 + GenUtils.randInt(0, 15);
            int z = data.getChunkZ() * 16 + GenUtils.randInt(0, 15);
            int y = GenUtils.getHighestGround(data, x, z);
            if (data.getBiome(x, z) != this.getBiome()) continue;
            SavannaHandler.makeYellowPatch(x, y, z, data, random);
        }
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getTrueHighestBlock(data, x, z);
                if (data.getBiome(x, z) != this.getBiome() || data.getType(x, y, z) != Material.GRASS_BLOCK || data.getType(x, y + 1, z).isSolid() || !GenUtils.chance(random, 5, 10)) continue;
                BlockUtils.setDoublePlant(data, x, y + 1, z, Material.TALL_GRASS);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] poffs;
        int treeY;
        boolean spawnedLargeSavannaTree = false;
        SimpleLocation[] trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 112, 0.6f);
        if (TConfigOption.TREES_SAVANNA_BIG_ENABLED.getBoolean()) {
            for (SimpleLocation sLoc : trees) {
                treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
                sLoc.setY(treeY);
                if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
                new FractalTreeBuilder(FractalTypes.Tree.SAVANNA_BIG).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
                spawnedLargeSavannaTree = true;
            }
        }
        if (!spawnedLargeSavannaTree) {
            for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 32)) {
                treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
                sLoc.setY(treeY);
                if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
                new FractalTreeBuilder(FractalTypes.Tree.SAVANNA_SMALL).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
            }
        }
        for (SimpleLocation sLoc : poffs = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 31)) {
            int treeY2 = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(treeY2);
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ())) || data.getType(sLoc.getX(), sLoc.getY() + 1, sLoc.getZ()).isSolid()) continue;
            SimpleBlock base = new SimpleBlock(data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
            int rX = GenUtils.randInt(random, 2, 4);
            int rY = GenUtils.randInt(random, 2, 4);
            int rZ = GenUtils.randInt(random, 2, 4);
            BlockUtils.replaceSphere(random.nextInt(999), (float)rX, (float)rY, (float)rZ, base, false, Material.ACACIA_LEAVES);
        }
    }
}

