/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class PlainsHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.PLAINS;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.GRASS_BLOCK, Material.DIRT, Material.DIRT, GenUtils.randMaterial(rand, Material.DIRT, Material.STONE), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        SimpleBlock target;
        int[] loc;
        int i;
        if (GenUtils.chance(1, 1000)) {
            for (i = 0; i < GenUtils.randInt(5, 10); ++i) {
                loc = GenUtils.randomSurfaceCoordinates(random, data);
                if (data.getBiome(loc[0], loc[2]) != this.getBiome() || (target = new SimpleBlock(data, loc[0], GenUtils.getHighestGround(data, loc[0], loc[2]) + 1, loc[2])).getType().isSolid()) continue;
                target.setType(Material.PUMPKIN);
            }
        }
        if (GenUtils.chance(1, 1000)) {
            for (i = 0; i < GenUtils.randInt(5, 10); ++i) {
                loc = GenUtils.randomSurfaceCoordinates(random, data);
                if (data.getBiome(loc[0], loc[2]) != this.getBiome() || (target = new SimpleBlock(data, loc[0], GenUtils.getHighestGround(data, loc[0], loc[2]) + 1, loc[2])).getType().isSolid()) continue;
                target.setType(Material.MELON);
            }
        }
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getTrueHighestBlock(data, x, z);
                if (data.getBiome(x, z) != this.getBiome() || data.getType(x, y, z) != Material.GRASS_BLOCK || BlockUtils.isWet(new SimpleBlock(data, x, y, z)) || !GenUtils.chance(random, 1, 10)) continue;
                if (GenUtils.chance(random, 6, 10)) {
                    data.setType(x, y + 1, z, Material.GRASS);
                    if (!random.nextBoolean()) continue;
                    BlockUtils.setDoublePlant(data, x, y + 1, z, Material.TALL_GRASS);
                    continue;
                }
                if (GenUtils.chance(random, 7, 10)) {
                    data.setType(x, y + 1, z, BlockUtils.pickFlower());
                    continue;
                }
                BlockUtils.setDoublePlant(data, x, y + 1, z, BlockUtils.pickTallFlower());
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] trees;
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 16)) {
            int highestY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            if (BlockUtils.isWet(new SimpleBlock(data, sLoc.getX(), highestY + 1, sLoc.getZ()))) continue;
            if (random.nextBoolean()) {
                sLoc.setY(highestY);
                if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
                new FractalTreeBuilder(FractalTypes.Tree.NORMAL_SMALL).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
                continue;
            }
            sLoc.setY(highestY);
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            BlockUtils.replaceSphere(random.nextInt(424444), 2.0f, 2.0f, 2.0f, new SimpleBlock(data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ()), false, Material.OAK_LEAVES);
        }
    }
}

