/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.generator.ChunkGenerator;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeBlender;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class PetrifiedCliffsHandler
extends BiomeHandler {
    static BiomeBlender biomeBlender;

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.BIRCH_FOREST;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.GRASS_BLOCK, Material.DIRT, Material.DIRT, GenUtils.randMaterial(rand, Material.DIRT, Material.STONE), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getTrueHighestBlock(data, x, z);
                if (data.getBiome(x, z) != this.getBiome()) continue;
                for (int i = 0; i < 30 && (data.getType(x, y, z) == Material.DIORITE || data.getType(x, y, z) == Material.ANDESITE || data.getType(x, y, z) == Material.GRANITE || data.getType(x, y, z) == Material.POLISHED_DIORITE || data.getType(x, y, z) == Material.POLISHED_ANDESITE || data.getType(x, y, z) == Material.POLISHED_GRANITE); ++i) {
                    --y;
                }
                if (data.getType(x, y, z) != Material.GRASS_BLOCK) continue;
                SimpleBlock core = new SimpleBlock(data, x, y + 1, z);
                boolean continueOut = false;
                for (BlockFace face : BlockUtils.directBlockFaces) {
                    if (!core.getRelative(face).getType().toString().endsWith("STONE")) continue;
                    core.setType(Material.DIORITE_SLAB);
                    continueOut = true;
                    break;
                }
                if (continueOut || !GenUtils.chance(random, 1, 10)) continue;
                if (GenUtils.chance(random, 6, 10)) {
                    data.setType(x, y + 1, z, Material.GRASS);
                    if (!random.nextBoolean()) continue;
                    BlockUtils.setDoublePlant(data, x, y + 1, z, Material.TALL_GRASS);
                    continue;
                }
                if (GenUtils.chance(random, 7, 10)) {
                    data.setType(x, y + 1, z, BlockUtils.pickFlower());
                    continue;
                }
                BlockUtils.setDoublePlant(data, x, y + 1, z, BlockUtils.pickTallFlower());
            }
        }
    }

    @Override
    public BiomeHandler getTransformHandler() {
        return this;
    }

    @Override
    public int getMaxHeightForCaves(TerraformWorld tw, int x, int z) {
        return (int)HeightMap.CORE.getHeight(tw, x, z);
    }

    @Override
    public void transformTerrain(TerraformWorld tw, Random random, ChunkGenerator.ChunkData chunk, int chunkX, int chunkZ) {
        FastNoise noise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_PETRIFIEDCLIFFS_CLIFFNOISE, world -> {
            FastNoise n = new FastNoise(tw.getHashedRand(123L, 2222, 1111).nextInt(99999));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.03f);
            return n;
        });
        FastNoise details = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_PETRIFIEDCLIFFS_INNERNOISE, world -> {
            FastNoise n = new FastNoise(tw.getHashedRand(111L, 66, 1).nextInt(99999));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.05f);
            return n;
        });
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double noiseValue;
                int rawX = chunkX * 16 + x;
                int rawZ = chunkZ * 16 + z;
                double preciseHeight = HeightMap.getPreciseHeight(tw, rawX, rawZ);
                int height = (int)preciseHeight;
                if (tw.getBiomeBank(rawX, height, rawZ) != BiomeBank.PETRIFIED_CLIFFS || (noiseValue = (double)Math.max(0.0f, noise.GetNoise(rawX, rawZ)) * PetrifiedCliffsHandler.getBiomeBlender(tw).getEdgeFactor(BiomeBank.PETRIFIED_CLIFFS, rawX, rawZ)) == 0.0) continue;
                double platformHeight = 7.0 + noiseValue * 50.0;
                if (platformHeight > 15.0) {
                    platformHeight = 15.0 + Math.sqrt(0.5 * (platformHeight - 15.0));
                }
                for (int y = 1; y <= (int)Math.round(platformHeight); ++y) {
                    double detailsNoiseMultiplier = Math.pow(1.0 - 1.0 / Math.pow(platformHeight / 2.0, 2.0) * Math.pow((double)y - platformHeight / 2.0, 2.0), 2.0);
                    double detailsNoise = details.GetNoise(rawX, height + y, rawZ);
                    if (!(0.85 + detailsNoise > detailsNoiseMultiplier)) continue;
                    chunk.setBlock(x, height + y, z, GenUtils.randMaterial(Material.STONE, Material.STONE, Material.STONE, Material.COBBLESTONE, Material.MOSSY_COBBLESTONE));
                }
            }
        }
    }

    private static BiomeBlender getBiomeBlender(TerraformWorld tw) {
        if (biomeBlender == null) {
            biomeBlender = new BiomeBlender(tw, true, true).setRiverThreshold(4).setBlendBeaches(false);
        }
        return biomeBlender;
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] trees;
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 13, 0.2f)) {
            if (!random.nextBoolean()) continue;
            int treeY = GenUtils.getTrueHighestBlock(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(treeY);
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()).toString().endsWith("STONE")) continue;
            new FractalTreeBuilder(switch (random.nextInt(3)) {
                case 0 -> FractalTypes.Tree.ANDESITE_PETRIFIED_SMALL;
                case 1 -> FractalTypes.Tree.GRANITE_PETRIFIED_SMALL;
                default -> FractalTypes.Tree.DIORITE_PETRIFIED_SMALL;
            }).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
        }
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.ROCKY_BEACH;
    }
}

