/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.tree.FractalTypes;
import org.terraform.tree.MushroomBuilder;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class MuddyBogHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.SWAMP;
    }

    @Override
    public CustomBiomeType getCustomBiome() {
        return CustomBiomeType.MUDDY_BOG;
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.BOG_BEACH;
    }

    @Override
    public BiomeBank getRiverType() {
        return BiomeBank.BOG_RIVER;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.GRASS_BLOCK, Material.DIRT, Material.DIRT, GenUtils.randMaterial(rand, Material.DIRT, Material.STONE), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                SimpleBlock block;
                int y = GenUtils.getHighestGround(data, x, z);
                if (data.getBiome(x, z) != this.getBiome() || (block = new SimpleBlock(data, x, y, z)).getRelative(0, 1, 0).getType() != Material.AIR || block.getType() != Material.GRASS_BLOCK) continue;
                if (GenUtils.chance(random, 1, 85)) {
                    block.getRelative(0, 1, 0).setType(Material.DEAD_BUSH);
                    continue;
                }
                if (GenUtils.chance(random, 1, 85)) {
                    block.getRelative(0, 1, 0).setType(Material.BROWN_MUSHROOM);
                    continue;
                }
                if (GenUtils.chance(random, 1, 85)) {
                    block.getRelative(0, 1, 0).setType(Material.GRASS);
                    continue;
                }
                if (GenUtils.chance(random, 1, 85)) {
                    BlockUtils.setDoublePlant(data, x, y + 1, z, Material.TALL_GRASS);
                    continue;
                }
                if (!GenUtils.chance(random, 1, 300)) continue;
                BlockUtils.replaceCircularPatch(random.nextInt(9999), 2.5f, block, OneOneSevenBlockHandler.DRIPSTONE_BLOCK);
                if (GenUtils.chance(random, 1, 7)) {
                    OneOneSevenBlockHandler.upLPointedDripstone(GenUtils.randInt(random, 2, 4), block.getRelative(0, 1, 0));
                }
                for (BlockFace face : BlockUtils.xzPlaneBlockFaces) {
                    if (!GenUtils.chance(random, 1, 7)) continue;
                    OneOneSevenBlockHandler.upLPointedDripstone(GenUtils.randInt(random, 2, 4), block.getRelative(face).getGround().getRelative(0, 1, 0));
                }
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] shrooms;
        for (SimpleLocation sLoc : shrooms = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 16)) {
            int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(treeY);
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || BlockUtils.isWet(new SimpleBlock(data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ())) || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ())) || data.getType(sLoc.getX(), sLoc.getY() + 1, sLoc.getZ()) != Material.AIR) continue;
            if (random.nextBoolean()) {
                new MushroomBuilder(FractalTypes.Mushroom.SMALL_BROWN_MUSHROOM).build(tw, data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
                continue;
            }
            new MushroomBuilder(FractalTypes.Mushroom.TINY_BROWN_MUSHROOM).build(tw, data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
        }
    }

    @Override
    public double calculateHeight(TerraformWorld tw, int x, int z) {
        double height = super.calculateHeight(tw, x, z) - 5.0;
        FastNoise sinkin = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_MUDDYBOG_HEIGHTMAP, world -> {
            FastNoise n = new FastNoise((int)world.getSeed());
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(4);
            n.SetFrequency(0.08f);
            return n;
        });
        if ((double)sinkin.GetNoise(x, z) < -0.15 && height > (double)TerraformGenerator.seaLevel) {
            height -= height - (double)TerraformGenerator.seaLevel + 2.0;
        }
        return height;
    }
}

