/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.generator.ChunkGenerator;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeBlender;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class GorgeHandler
extends BiomeHandler {
    static BiomeBlender biomeBlender;
    static BiomeHandler plainsHandler;
    static boolean slabs;

    @Override
    public boolean isOcean() {
        return plainsHandler.isOcean();
    }

    @Override
    public Biome getBiome() {
        return plainsHandler.getBiome();
    }

    @Override
    public double calculateHeight(TerraformWorld tw, int x, int z) {
        double height = super.calculateHeight(tw, x, z);
        double riverDepth = HeightMap.getRawRiverDepth(tw, x, z);
        if (riverDepth > 0.0) {
            height += riverDepth;
        }
        return height;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return plainsHandler.getSurfaceCrust(rand);
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                if (data.getBiome(x, z) != this.getBiome()) continue;
                SimpleBlock target = new SimpleBlock(data, x, y + 1, z);
                while (target.getY() <= TerraformGenerator.seaLevel) {
                    if (target.getY() <= TerraformGenerator.seaLevel - 20) {
                        if (target.getType() == Material.WATER) {
                            for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.DOWN}) {
                                if (target.getRelative(face).getType() != Material.AIR) continue;
                                target.getRelative(face).setType(Material.STONE);
                            }
                        }
                    } else {
                        for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.SELF}) {
                            if (target.getRelative(face).getType() != Material.WATER) continue;
                            target.getRelative(face).setType(Material.STONE);
                            if (face != BlockFace.SELF) continue;
                            target.getRelative(face).setType(Material.STONE);
                        }
                    }
                    target = target.getRelative(0, 1, 0);
                }
                if (BlockUtils.isWet((target = target.getGround()).getRelative(0, 1, 0)) || target.getType() != Material.STONE) continue;
                target.setType(Material.GRASS_BLOCK);
                target.getRelative(0, -1, 0).setType(Material.DIRT);
                if (!random.nextBoolean()) continue;
                target.getRelative(0, -2, 0).setType(Material.DIRT);
                if (!random.nextBoolean()) continue;
                target.getRelative(0, -3, 0).setType(Material.DIRT);
            }
        }
        plainsHandler.populateSmallItems(world, random, data);
    }

    @Override
    public BiomeHandler getTransformHandler() {
        return this;
    }

    @Override
    public void transformTerrain(TerraformWorld tw, Random random, ChunkGenerator.ChunkData chunk, int chunkX, int chunkZ) {
        FastNoise cliffNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_GORGE_CLIFFNOISE, world -> {
            FastNoise n = new FastNoise();
            n.SetNoiseType(FastNoise.NoiseType.CubicFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.04f);
            return n;
        });
        FastNoise detailsNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_GORGE_DETAILS, world -> {
            FastNoise n = new FastNoise();
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFrequency(0.03f);
            return n;
        });
        double threshold = 0.1;
        int heightFactor = 12;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int rawX = chunkX * 16 + x;
                int rawZ = chunkZ * 16 + z;
                double preciseHeight = HeightMap.getPreciseHeight(tw, rawX, rawZ);
                int height = (int)preciseHeight;
                if (tw.getBiomeBank(rawX, height, rawZ) != BiomeBank.GORGE) continue;
                double rawCliffNoiseVal = cliffNoise.GetNoise(rawX, rawZ);
                double noiseValue = rawCliffNoiseVal * GorgeHandler.getBiomeBlender(tw).getEdgeFactor(BiomeBank.GORGE, rawX, rawZ);
                double detailsValue = detailsNoise.GetNoise(rawX, rawZ);
                if (noiseValue >= 0.0) {
                    double d = noiseValue / threshold - (double)((int)(noiseValue / threshold)) - 0.5;
                    double platformHeight = (double)((int)(noiseValue / threshold) * heightFactor) + 64.0 * Math.pow(d, 7.0) * (double)heightFactor + detailsValue * (double)heightFactor * 0.5;
                    for (int y = 1; y <= (int)Math.round(platformHeight); ++y) {
                        Material material = GenUtils.randMaterial(Material.STONE, Material.STONE, Material.STONE, Material.STONE, Material.COBBLESTONE, Material.COBBLESTONE, Material.ANDESITE, Material.ANDESITE);
                        if (slabs && material != Material.GRASS_BLOCK && y == (int)Math.round(platformHeight) && platformHeight - (double)((int)platformHeight) >= 0.5) {
                            material = Material.getMaterial((String)(material.name() + "_SLAB"));
                        }
                        chunk.setBlock(x, height + y, z, material);
                    }
                    if (!(detailsValue < 0.2) || !GenUtils.chance(3, 4)) continue;
                    chunk.setBlock(x, height + (int)Math.round(platformHeight), z, Material.GRASS_BLOCK);
                    continue;
                }
                int depth = (int)Math.sqrt(Math.abs(rawCliffNoiseVal * GorgeHandler.getBiomeBlender(tw).getEdgeFactor(BiomeBank.GORGE, rawX, rawZ)) * 200.0 * 50.0);
                if (height - depth < TerraformGenerator.seaLevel - 20) {
                    int depthToPreserve = height - (TerraformGenerator.seaLevel - 20);
                    depth = (int)((long)depthToPreserve + Math.round(Math.sqrt(depth - depthToPreserve)));
                }
                if (depth > height - 10) {
                    depth = height - 10;
                }
                for (int y = 0; y < depth; ++y) {
                    if (TerraformGenerator.seaLevel - 20 >= height - y) {
                        chunk.setBlock(x, height - y, z, Material.WATER);
                        continue;
                    }
                    chunk.setBlock(x, height - y, z, Material.AIR);
                }
            }
        }
    }

    private static BiomeBlender getBiomeBlender(TerraformWorld tw) {
        if (biomeBlender == null) {
            biomeBlender = new BiomeBlender(tw, true, true).setGridBlendingFactor(2.0).setSmoothBlendTowardsRivers(4);
        }
        return biomeBlender;
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] rocks;
        plainsHandler.populateLargeItems(tw, random, data);
        for (SimpleLocation sLoc : rocks = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 17, 0.4f)) {
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome()) continue;
            int rockY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(rockY);
            if (rockY > TerraformGenerator.seaLevel - 18) continue;
            BlockUtils.replaceSphere(random.nextInt(91822), (float)GenUtils.randDouble(random, 3.0, 6.0), (float)GenUtils.randDouble(random, 4.0, 7.0), (float)GenUtils.randDouble(random, 3.0, 6.0), new SimpleBlock(data, sLoc), true, GenUtils.randMaterial(Material.GRANITE, Material.ANDESITE, Material.DIORITE));
        }
    }

    static {
        plainsHandler = BiomeBank.PLAINS.getHandler();
        slabs = TConfigOption.MISC_USE_SLABS_TO_SMOOTH.getBoolean();
    }
}

