/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class ForestHandler
extends BiomeHandler {
    private static void spawnRock(Random rand, PopulatorDataAbstract data, int x, int y, int z) {
        ArrayList<int[]> locations = new ArrayList<int[]>(20);
        locations.add(new int[]{x, y, z});
        locations.add(new int[]{x, y + 1, z});
        locations.add(new int[]{x + 1, y + 1, z});
        locations.add(new int[]{x - 1, y + 1, z});
        locations.add(new int[]{x, y + 1, z + 1});
        locations.add(new int[]{x, y + 1, z - 1});
        locations.add(new int[]{x + 1, y, z});
        locations.add(new int[]{x - 1, y, z});
        locations.add(new int[]{x, y, z + 1});
        locations.add(new int[]{x, y, z - 1});
        locations.add(new int[]{x + 1, y, z});
        locations.add(new int[]{x - 1, y, z + 1});
        locations.add(new int[]{x + 1, y, z + 1});
        locations.add(new int[]{x - 1, y, z - 1});
        locations.add(new int[]{x, y - 1, z});
        locations.add(new int[]{x + 1, y - 1, z});
        locations.add(new int[]{x - 1, y - 1, z});
        locations.add(new int[]{x, y - 1, z + 1});
        locations.add(new int[]{x, y - 1, z - 1});
        for (int[] coords : locations) {
            int Tz;
            int Ty;
            int Tx = coords[0];
            if (data.getType(Tx, Ty = coords[1], Tz = coords[2]).isSolid() && !data.getType(Tx, Ty, Tz).toString().contains("LEAVES")) continue;
            data.setType(Tx, Ty, Tz, GenUtils.randMaterial(rand, Material.COBBLESTONE, Material.STONE, Material.MOSSY_COBBLESTONE));
        }
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.FOREST;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{GenUtils.weightedRandomMaterial(rand, Material.GRASS_BLOCK, 35, Material.PODZOL, 3), Material.DIRT, Material.DIRT, GenUtils.randMaterial(rand, Material.DIRT, Material.STONE), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        FastNoise pathNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_FOREST_PATHNOISE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 12L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.07f);
            return n;
        });
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                if ((double)pathNoise.GetNoise(x, z) > 0.3 && GenUtils.chance(random, 99, 100) && data.getBiome(x, z) == this.getBiome() && BlockUtils.isDirtLike(data.getType(x, y, z))) {
                    data.setType(x, y, z, OneOneSevenBlockHandler.DIRT_PATH());
                }
                if (data.getType(x, y, z) != Material.GRASS_BLOCK || !GenUtils.chance(random, 1, 10) || data.getType(x, y + 1, z) != Material.AIR) continue;
                data.setType(x, y + 1, z, Material.GRASS);
                if (random.nextBoolean()) {
                    BlockUtils.setDoublePlant(data, x, y + 1, z, Material.TALL_GRASS);
                    continue;
                }
                data.setType(x, y + 1, z, BlockUtils.pickFlower());
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] rocks;
        SimpleLocation[] trees;
        int treeY;
        int treeZ;
        int treeX;
        if (TConfigOption.TREES_FOREST_BIG_ENABLED.getBoolean() && GenUtils.chance(random, 6, 10) && data.getBiome(treeX = GenUtils.randInt(random, 2, 12) + data.getChunkX() * 16, treeZ = GenUtils.randInt(random, 2, 12) + data.getChunkZ() * 16) == this.getBiome() && BlockUtils.isDirtLike(data.getType(treeX, treeY = GenUtils.getHighestGround(data, treeX, treeZ), treeZ))) {
            FractalTypes.Tree.FOREST.build(tw, new SimpleBlock(data, treeX, treeY, treeZ));
        }
        for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 8)) {
            int treeY2 = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(treeY2);
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            FractalTypes.Tree.NORMAL_SMALL.build(tw, new SimpleBlock(data, sLoc.getX(), sLoc.getY(), sLoc.getZ()));
        }
        for (SimpleLocation sLoc : rocks = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 10)) {
            sLoc.setY(GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ()));
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ())) && data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.COBBLESTONE && data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.MOSSY_COBBLESTONE && data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.STONE) continue;
            int ny = GenUtils.randInt(random, -1, 1);
            ForestHandler.spawnRock(random, data, sLoc.getX(), sLoc.getY() + ny, sLoc.getZ());
            if (!GenUtils.chance(random, 1, 3)) continue;
            ForestHandler.spawnRock(random, data, GenUtils.randInt(random, -1, 1) + sLoc.getX(), sLoc.getY() + ny + 1, sLoc.getZ() + GenUtils.randInt(random, -1, 1));
        }
    }
}

