/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Axis;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.generator.ChunkGenerator;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.biome.beach.OasisBeach;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.small.DesertWellPopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.OrientableBuilder;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class DesertHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.DESERT;
    }

    @Override
    public BiomeHandler getTransformHandler() {
        return this;
    }

    @Override
    public BiomeBank getRiverType() {
        return BiomeBank.DESERT_RIVER;
    }

    @Override
    public void transformTerrain(TerraformWorld tw, Random random, ChunkGenerator.ChunkData chunk, ChunkGenerator.BiomeGrid biome, int chunkX, int chunkZ) {
        OasisBeach.transformTerrain(tw, biome, chunkX, chunkZ, BiomeBank.DESERT);
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.SAND, Material.SAND, GenUtils.randMaterial(rand, Material.SANDSTONE, Material.SAND), Material.SANDSTONE, Material.SANDSTONE, Material.SANDSTONE, Material.SANDSTONE, GenUtils.randMaterial(rand, Material.SANDSTONE, Material.STONE), GenUtils.randMaterial(rand, Material.SANDSTONE, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        boolean cactusGathering = GenUtils.chance(random, 1, 100);
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                OasisBeach.generateOasisBeach(world, random, data, x, z, BiomeBank.DESERT);
                int y = GenUtils.getTrueHighestBlock(data, x, z);
                if (data.getBiome(x, z) != this.getBiome()) continue;
                Material base = data.getType(x, y, z);
                if (cactusGathering && GenUtils.chance(random, 5, 100)) {
                    data.setType(x, y, z, OneOneSevenBlockHandler.DIRT_PATH());
                }
                if (base != Material.SAND) continue;
                if (GenUtils.chance(random, 1, 100) || GenUtils.chance(random, 1, 20) && cactusGathering) {
                    boolean canSpawn = true;
                    for (BlockFace face : BlockUtils.directBlockFaces) {
                        if (data.getType(x + face.getModX(), y + 1, z + face.getModZ()) == Material.AIR) continue;
                        canSpawn = false;
                    }
                    if (!canSpawn) continue;
                    BlockUtils.spawnPillar(random, data, x, y + 1, z, Material.CACTUS, 3, 5);
                    continue;
                }
                if (!GenUtils.chance(random, 1, 80)) continue;
                data.setType(x, y + 1, z, Material.DEAD_BUSH);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] ribCages;
        for (SimpleLocation sLoc : ribCages = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 256, 0.6f)) {
            int ribY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(ribY - GenUtils.randInt(random, 0, 6));
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || data.getType(sLoc.getX(), ribY, sLoc.getZ()) != Material.SAND) continue;
            this.spawnRibCage(random, new SimpleBlock(data, sLoc.getX(), sLoc.getY(), sLoc.getZ()));
        }
        if (GenUtils.chance(random, TConfigOption.STRUCTURES_DESERTWELL_CHANCE_OUT_OF_TEN_THOUSAND.getInt(), 10000)) {
            new DesertWellPopulator().populate(tw, random, data, false);
        }
    }

    public void spawnRibCage(Random random, SimpleBlock target) {
        BlockFace direction = BlockUtils.getDirectBlockFace(random);
        int spineLength = GenUtils.randInt(random, 10, 14);
        float ribWidthRadius = GenUtils.randInt(random, 1, 2) + spineLength / 2;
        float ribHeightRadius = 0.7f * ribWidthRadius;
        int interval = 2;
        if (random.nextBoolean()) {
            ++interval;
        }
        float ribSizeMultiplier = 1.0f;
        for (int segmentIndex = 0; segmentIndex < spineLength; ++segmentIndex) {
            Wall seg = new Wall(target.getRelative(direction, segmentIndex), direction);
            new OrientableBuilder(Material.BONE_BLOCK).setAxis(BlockUtils.getAxisFromBlockFace(direction)).apply(seg);
            if (segmentIndex < (int)((float)spineLength / 2.0f)) {
                ribSizeMultiplier += 0.05f;
            } else if (segmentIndex > (int)((float)spineLength / 2.0f)) {
                ribSizeMultiplier -= 0.05f;
            }
            if (segmentIndex % interval != 0 || segmentIndex <= spineLength / 6) continue;
            float nHor = 1.0f;
            while (nHor <= ribWidthRadius * ribSizeMultiplier) {
                int[] multipliers = new int[]{-1};
                if (nHor > ribWidthRadius * ribSizeMultiplier / 3.0f) {
                    multipliers = new int[]{-1, 1};
                }
                for (int multiplier : multipliers) {
                    int ny = (int)Math.round((double)(ribHeightRadius * ribSizeMultiplier) + (double)((float)multiplier * ribHeightRadius * ribSizeMultiplier) * Math.sqrt(1.0 - Math.pow(nHor / (ribWidthRadius * ribSizeMultiplier), 2.0)));
                    int horRel = Math.round(nHor);
                    Axis axis = BlockUtils.getAxisFromBlockFace(BlockUtils.getLeft(direction));
                    if ((float)ny > ribSizeMultiplier * ribHeightRadius / 3.0f && (float)ny < 5.0f * ribSizeMultiplier * ribHeightRadius / 3.0f) {
                        axis = Axis.Y;
                    }
                    new OrientableBuilder(Material.BONE_BLOCK).setAxis(axis).apply(seg.getRelative(0, ny, 0).getRight(horRel)).apply(seg.getRelative(0, ny, 0).getLeft(horRel));
                }
                nHor = (float)((double)nHor + 0.01);
            }
        }
    }
}

