/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeHandler;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.tree.FractalTreeBuilder;
import org.terraform.tree.FractalTypes;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.SphereBuilder;
import org.terraform.utils.version.OneOneSevenBlockHandler;
import org.terraform.utils.version.Version;

public class CherryGroveHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.PLAINS;
    }

    @Override
    public CustomBiomeType getCustomBiome() {
        return CustomBiomeType.CHERRY_GROVE;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.GRASS_BLOCK, Material.DIRT, Material.DIRT, GenUtils.randMaterial(rand, Material.DIRT, Material.STONE), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                if (data.getBiome(x, z) != this.getBiome() || data.getType(x, y, z) != Material.GRASS_BLOCK || !GenUtils.chance(random, 1, 10)) continue;
                if (GenUtils.chance(random, 6, 10)) {
                    data.setType(x, y + 1, z, Material.GRASS);
                    if (!random.nextBoolean()) continue;
                    BlockUtils.setDoublePlant(data, x, y + 1, z, Material.TALL_GRASS);
                    continue;
                }
                if (GenUtils.chance(random, 7, 10)) {
                    data.setType(x, y + 1, z, Material.ALLIUM);
                    continue;
                }
                BlockUtils.setDoublePlant(data, x, y + 1, z, Material.PEONY);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] trees;
        block3: for (SimpleLocation sLoc : trees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 20)) {
            int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(treeY);
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()))) continue;
            switch (random.nextInt(20)) {
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    new SphereBuilder(random, new SimpleBlock(data, sLoc), Material.COBBLESTONE, Material.STONE, Material.STONE, Material.STONE, Material.MOSSY_COBBLESTONE).setRadius(GenUtils.randInt(random, 3, 5)).setRY(GenUtils.randInt(random, 6, 10)).build();
                    continue block3;
                }
                default: {
                    if (random.nextBoolean()) {
                        new FractalTreeBuilder(FractalTypes.Tree.CHERRY_SMALL).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
                    } else {
                        new FractalTreeBuilder(FractalTypes.Tree.CHERRY_THICK).build(tw, data, sLoc.getX(), sLoc.getY(), sLoc.getZ());
                    }
                    if (!Version.isAtLeast(17.0)) continue block3;
                    for (int rX = sLoc.getX() - 6; rX <= sLoc.getX() + 6; ++rX) {
                        for (int rZ = sLoc.getZ() - 6; rZ <= sLoc.getZ() + 6; ++rZ) {
                            Wall ceil = new Wall(new SimpleBlock(data, rX, sLoc.getY(), rZ)).findCeiling(15);
                            if (ceil == null || !GenUtils.chance(random, 1, 30) || ceil.getType() != Material.DARK_OAK_LEAVES) continue;
                            ceil.getRelative(0, -1, 0).setType(OneOneSevenBlockHandler.SPORE_BLOSSOM);
                        }
                    }
                }
            }
        }
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.CHERRY_GROVE_BEACH;
    }

    @Override
    public BiomeBank getRiverType() {
        return BiomeBank.CHERRY_GROVE_RIVER;
    }
}

