/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bamboo;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class BambooForestHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.BAMBOO_JUNGLE;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.GRASS_BLOCK, Material.DIRT, Material.DIRT, GenUtils.randMaterial(rand, Material.DIRT, Material.STONE), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        FastNoise pathNoise = NoiseCacheHandler.getNoise(world, NoiseCacheHandler.NoiseCacheEntry.BIOME_BAMBOOFOREST_PATHNOISE, tw -> {
            FastNoise n = new FastNoise((int)(tw.getSeed() * 13L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFractalOctaves(3);
            n.SetFrequency(0.07f);
            return n;
        });
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getTrueHighestBlock(data, x, z);
                if (data.getBiome(x, z) != this.getBiome()) continue;
                if ((double)pathNoise.GetNoise(x, z) > 0.27 && GenUtils.chance(random, 99, 100) && data.getBiome(x, z) == this.getBiome() && BlockUtils.isDirtLike(data.getType(x, y, z))) {
                    data.setType(x, y, z, Material.PODZOL);
                }
                if (data.getType(x, y, z) != Material.GRASS_BLOCK && data.getType(x, y, z) != Material.PODZOL || !GenUtils.chance(random, 1, 3)) continue;
                if (GenUtils.chance(random, 6, 10)) {
                    data.setType(x, y + 1, z, Material.GRASS);
                    if (!random.nextBoolean()) continue;
                    BlockUtils.setDoublePlant(data, x, y + 1, z, Material.TALL_GRASS);
                    continue;
                }
                if (GenUtils.chance(random, 7, 10)) {
                    data.setType(x, y + 1, z, Material.FERN);
                    continue;
                }
                BlockUtils.setDoublePlant(data, x, y + 1, z, Material.LARGE_FERN);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getTrueHighestBlock(data, x, z);
                if (data.getBiome(x, z) != this.getBiome() || data.getType(x, y, z) != Material.GRASS_BLOCK && data.getType(x, y, z) != Material.PODZOL) continue;
                if (GenUtils.chance(random, 1, 50)) {
                    BlockUtils.replaceSphere(random.nextInt(424444), 2.0f, 3.0f, 2.0f, new SimpleBlock(data, x, y + 1, z), false, Material.JUNGLE_LEAVES);
                }
                if (!GenUtils.chance(random, 1, 3) || !BlockUtils.isDirtLike(data.getType(x, y, z))) continue;
                int h2 = BlockUtils.spawnPillar(random, data, x, y + 1, z, Material.BAMBOO, 12, 16);
                Bamboo bambooHead = (Bamboo)Bukkit.createBlockData((Material)Material.BAMBOO);
                bambooHead.setLeaves(Bamboo.Leaves.LARGE);
                data.setBlockData(x, y + h2, z, (BlockData)bambooHead);
                bambooHead = (Bamboo)Bukkit.createBlockData((Material)Material.BAMBOO);
                bambooHead.setLeaves(Bamboo.Leaves.LARGE);
                data.setBlockData(x, y + h2 - 1, z, (BlockData)bambooHead);
                bambooHead = (Bamboo)Bukkit.createBlockData((Material)Material.BAMBOO);
                bambooHead.setLeaves(Bamboo.Leaves.SMALL);
                data.setBlockData(x, y + h2 - 2, z, (BlockData)bambooHead);
            }
        }
    }
}

