/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.flat;

import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.generator.ChunkGenerator;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeBlender;
import org.terraform.biome.BiomeHandler;
import org.terraform.biome.beach.OasisBeach;
import org.terraform.biome.mountainous.BadlandsCanyonHandler;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.small.DesertWellPopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class BadlandsHandler
extends BiomeHandler {
    private static BiomeBlender riversBlender;
    private static BiomeBlender plateauBlender;
    static int sandRadius;
    static int plateauHeight;
    static float plateauFrequency;
    static double plateauThreshold;
    static double plateauCommonness;

    private static BiomeBlender getRiversBlender(TerraformWorld tw) {
        if (riversBlender == null) {
            riversBlender = new BiomeBlender(tw, true, false).setGridBlendingFactor(0.45);
        }
        return riversBlender;
    }

    private static BiomeBlender getPlateauBlender(TerraformWorld tw) {
        if (plateauBlender == null) {
            plateauBlender = new BiomeBlender(tw, true, true).setRiverThreshold(10);
        }
        return plateauBlender;
    }

    public static FastNoise getPlateauNoise(TerraformWorld tw) {
        return NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_BADLANDS_PLATEAUNOISE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 7509L));
            n.SetNoiseType(FastNoise.NoiseType.CubicFractal);
            n.SetFractalOctaves(2);
            n.SetFrequency(plateauFrequency);
            return n;
        });
    }

    @Override
    public BiomeBank getRiverType() {
        return BiomeBank.BADLANDS_RIVER;
    }

    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.BADLANDS;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.RED_SAND, Material.RED_SAND, GenUtils.randMaterial(rand, Material.RED_SAND, Material.RED_SANDSTONE), GenUtils.randMaterial(rand, Material.RED_SANDSTONE, Material.STONE), GenUtils.randMaterial(rand, Material.RED_SANDSTONE, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        this.generatePlateaus(world, data);
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                OasisBeach.generateOasisBeach(world, random, data, x, z, BiomeBank.BADLANDS);
                int highest = GenUtils.getTrueHighestBlock(data, x, z);
                BiomeBank currentBiome = world.getBiomeBank(x, highest, z);
                if (currentBiome != BiomeBank.BADLANDS && currentBiome != BiomeBank.BADLANDS_BEACH && currentBiome != BiomeBank.BADLANDS_CANYON) continue;
                if (HeightMap.getNoiseGradient(world, x, z, 3) >= 1.5 && GenUtils.chance(random, 49, 50)) {
                    BadlandsCanyonHandler.oneUnit(world, random, data, x, z, true);
                    continue;
                }
                Material base = data.getType(x, highest, z);
                if (base != Material.SAND && base != Material.RED_SAND) continue;
                if (GenUtils.chance(random, 1, 200)) {
                    boolean canSpawn = true;
                    for (BlockFace face : BlockUtils.directBlockFaces) {
                        if (data.getType(x + face.getModX(), highest + 1, z + face.getModZ()) == Material.AIR) continue;
                        canSpawn = false;
                    }
                    if (HeightMap.getBlockHeight(world, x, z) + 5 < highest) {
                        canSpawn = false;
                    }
                    if (canSpawn && GenUtils.chance(1, 50)) {
                        this.spawnDeadTree(data, x, highest, z);
                        continue;
                    }
                    if (!canSpawn) continue;
                    BlockUtils.spawnPillar(random, data, x, highest + 1, z, Material.CACTUS, 2, 5);
                    continue;
                }
                if (!GenUtils.chance(random, 1, 80) || highest <= TerraformGenerator.seaLevel) continue;
                data.setType(x, highest + 1, z, Material.DEAD_BUSH);
            }
        }
    }

    @Override
    public BiomeHandler getTransformHandler() {
        return this;
    }

    @Override
    public void transformTerrain(TerraformWorld tw, Random random, ChunkGenerator.ChunkData chunk, ChunkGenerator.BiomeGrid biome, int chunkX, int chunkZ) {
        OasisBeach.transformTerrain(tw, biome, chunkX, chunkZ, BiomeBank.BADLANDS);
        BiomeBlender blender = BadlandsHandler.getRiversBlender(tw);
        FastNoise wallNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_BADLANDS_WALLNOISE, world -> {
            FastNoise n = new FastNoise((int)(tw.getWorld().getSeed() * 2L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFrequency(0.07f);
            n.SetFractalOctaves(2);
            return n;
        });
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int buildHeight;
                int rawX = chunkX * 16 + x;
                int rawZ = chunkZ * 16 + z;
                double preciseHeight = HeightMap.getPreciseHeight(tw, rawX, rawZ);
                BiomeBank currentBiome = BiomeBank.calculateBiome(tw, rawX, TerraformGenerator.seaLevel, rawZ);
                if (currentBiome != BiomeBank.BADLANDS && currentBiome != BiomeBank.BADLANDS_CANYON && (currentBiome != BiomeBank.BADLANDS_BEACH || !(HeightMap.getRawRiverDepth(tw, rawX, rawZ) > 0.0))) continue;
                double riverlessHeight = HeightMap.getRiverlessHeight(tw, rawX, rawZ) - 2.0;
                double edgeFactor = blender.getEdgeFactor(BiomeBank.BADLANDS, rawX, rawZ);
                double bottomEdgeFactor = Math.min(2.0 * edgeFactor, 1.0);
                double topEdgeFactor = Math.max(2.0 * edgeFactor - 1.0, 0.0);
                double heightAboveSea = preciseHeight - 2.0 - (double)TerraformGenerator.seaLevel;
                double maxDiff = riverlessHeight - (double)TerraformGenerator.seaLevel;
                double riverFactor = heightAboveSea / maxDiff;
                if (!(riverFactor > 0.0) || !(heightAboveSea > 0.0)) continue;
                for (int i = buildHeight = (int)Math.round(bottomEdgeFactor * (Math.min(1.0, 4.0 * Math.pow(riverFactor, 4.0)) * maxDiff + (double)wallNoise.GetNoise(rawX, rawZ) * 1.5)); i >= 0; --i) {
                    int lowerHeight = Math.min(TerraformGenerator.seaLevel + i, (int)Math.round(riverlessHeight));
                    chunk.setBlock(x, lowerHeight, z, BlockUtils.getTerracotta(lowerHeight));
                }
                double threshold = 0.4 + (1.0 - topEdgeFactor) * 0.6;
                if (riverFactor > threshold) {
                    int upperBuildHeight = (int)Math.round(1.0 * (Math.min(1.0, 50.0 * Math.pow(riverFactor - threshold, 2.5)) * maxDiff + (double)wallNoise.GetNoise(rawX, rawZ) * 1.5));
                    if (topEdgeFactor == 0.0) continue;
                    for (int i = 0; i <= upperBuildHeight; ++i) {
                        int upperHeight = (int)riverlessHeight - i;
                        chunk.setBlock(x, upperHeight, z, BlockUtils.getTerracotta(upperHeight));
                    }
                }
                if (!(riverFactor > threshold + 0.12)) continue;
                chunk.setBlock(x, (int)riverlessHeight + 1, z, Material.RED_SAND);
            }
        }
    }

    void generatePlateaus(TerraformWorld tw, PopulatorDataAbstract data) {
        FastNoise detailsNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_BADLANDS_WALLNOISE, world -> {
            FastNoise n = new FastNoise((int)(tw.getSeed() * 7509L));
            n.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            n.SetFrequency(0.08f);
            return n;
        });
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int height = HeightMap.getBlockHeight(tw, x, z);
                double rawValue = Math.max(0.0, (double)BadlandsHandler.getPlateauNoise(tw).GetNoise(x, z) + plateauCommonness);
                double noiseValue = rawValue * BadlandsHandler.getPlateauBlender(tw).getEdgeFactor(BiomeBank.BADLANDS, x, z) * (1.0 - (double)((int)(rawValue / plateauThreshold)) * 0.05);
                double graduated = noiseValue / plateauThreshold;
                double platformHeight = (double)((int)graduated * plateauHeight) + 10.0 * Math.pow(graduated - (double)((int)graduated) - 0.5 - 0.1, 7.0) * (double)plateauHeight;
                boolean placeSand = false;
                for (int y = 1; y <= (int)Math.round(platformHeight); ++y) {
                    placeSand = true;
                    Material material = (int)graduated * plateauHeight == y ? Material.RED_SAND : ((int)graduated * plateauHeight == y + 1 ? GenUtils.randMaterial(Material.RED_SAND, Material.RED_SAND, BlockUtils.getTerracotta(height + y)) : ((int)graduated * plateauHeight == y + 2 ? GenUtils.randMaterial(Material.RED_SAND, BlockUtils.getTerracotta(height + y), BlockUtils.getTerracotta(height + y)) : BlockUtils.getTerracotta(height + y)));
                    data.setType(x, height + y, z, material);
                }
                if (!placeSand || graduated - (double)((int)graduated) > 0.2) continue;
                int level = ((int)graduated - 1) * plateauHeight;
                for (int sx = x - sandRadius; sx <= x + sandRadius; ++sx) {
                    for (int sz = z - sandRadius; sz <= z + sandRadius; ++sz) {
                        double distance = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sz - z, 2.0));
                        if (!(distance < (double)sandRadius) || (int)graduated != 1 && BadlandsHandler.getPlateauHeight(tw, sx, sz) != plateauHeight) continue;
                        int sandHeight = (int)Math.round((double)plateauHeight * 0.55 * Math.pow(1.0 - distance / (double)sandRadius, 1.7) + (double)detailsNoise.GetNoise(sx, sz));
                        for (int y = 1 + level; y <= sandHeight + level; ++y) {
                            if (data.getType(sx, HeightMap.getBlockHeight(tw, sx, sz) + y, sz) != Material.AIR) continue;
                            data.setType(sx, HeightMap.getBlockHeight(tw, sx, sz) + y, sz, Material.RED_SAND);
                        }
                    }
                }
            }
        }
    }

    public static boolean containsPlateau(TerraformWorld tw, int x, int z) {
        return BadlandsHandler.getPlateauHeight(tw, x, z) > 0;
    }

    public static boolean mineCanSpawn(TerraformWorld tw, int x, int z) {
        int h2 = BadlandsHandler.getPlateauHeight(tw, x, z);
        return h2 < plateauHeight - 1 && h2 > plateauHeight / 3;
    }

    static int getPlateauHeight(TerraformWorld tw, int x, int z) {
        double rawValue = Math.max(0.0, (double)BadlandsHandler.getPlateauNoise(tw).GetNoise(x, z) + plateauCommonness);
        double noiseValue = rawValue * BadlandsHandler.getPlateauBlender(tw).getEdgeFactor(BiomeBank.BADLANDS, x, z) * (1.0 - (double)((int)(rawValue / plateauThreshold)) * 0.1);
        double graduated = noiseValue / plateauThreshold;
        double platformHeight = (double)((int)graduated * plateauHeight) + 10.0 * Math.pow(graduated - (double)((int)graduated) - 0.5 - 0.1, 7.0) * (double)plateauHeight;
        return (int)Math.round(platformHeight);
    }

    void spawnDeadTree(PopulatorDataAbstract data, int x, int y, int z) {
        int height = GenUtils.randInt(5, 7);
        int branches = GenUtils.randInt(1, height == 5 ? 2 : 3);
        for (int i = 1; i <= height; ++i) {
            data.setType(x, y + i, z, Material.DARK_OAK_WOOD);
        }
        ArrayList<Integer> usedBranchHorizontals = new ArrayList<Integer>();
        ArrayList<Integer> usedBranchVerticals = new ArrayList<Integer>();
        for (int i = 0; i < branches; ++i) {
            int bHeight = GenUtils.randInt(2, height - 1);
            int bDirection = GenUtils.randInt(1, 4);
            if (usedBranchHorizontals.contains(bDirection) || usedBranchVerticals.contains(bHeight)) {
                --i;
                continue;
            }
            int bx = x;
            int bz = z;
            switch (bDirection) {
                case 1: {
                    ++bz;
                    break;
                }
                case 2: {
                    ++bx;
                    break;
                }
                case 3: {
                    --bz;
                    break;
                }
                default: {
                    --bx;
                }
            }
            data.setType(bx, y + bHeight, bz, Material.DARK_OAK_WOOD);
            usedBranchHorizontals.add(bDirection);
            usedBranchVerticals.add(bHeight);
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int highest = GenUtils.getTrueHighestBlock(data, x, z);
                BiomeBank currentBiome = tw.getBiomeBank(x, z);
                if (currentBiome != BiomeBank.BADLANDS && currentBiome != BiomeBank.BADLANDS_BEACH && currentBiome != BiomeBank.BADLANDS_CANYON) continue;
                if (HeightMap.getNoiseGradient(tw, x, z, 3) >= 1.5 && GenUtils.chance(random, 49, 50)) {
                    BadlandsCanyonHandler.oneUnit(tw, random, data, x, z, true);
                    continue;
                }
                Material base = data.getType(x, highest, z);
                if (base != Material.SAND && base != Material.RED_SAND || !GenUtils.chance(random, 1, 200)) continue;
                boolean canSpawn = true;
                for (BlockFace face : BlockUtils.directBlockFaces) {
                    if (data.getType(x + face.getModX(), highest + 1, z + face.getModZ()) == Material.AIR) continue;
                    canSpawn = false;
                }
                if (GenUtils.getHighestGround(data, x, z) + 5 < highest) {
                    canSpawn = false;
                }
                if (!canSpawn || !GenUtils.chance(1, 50)) continue;
                this.spawnDeadTree(data, x, highest, z);
            }
        }
        if (GenUtils.chance(random, TConfigOption.STRUCTURES_DESERTWELL_CHANCE_OUT_OF_TEN_THOUSAND.getInt(), 10000)) {
            new DesertWellPopulator().populate(tw, random, data, true);
        }
    }

    @Override
    public BiomeBank getBeachType() {
        return BiomeBank.BADLANDS_BEACH;
    }

    static {
        sandRadius = TConfigOption.BIOME_BADLANDS_PLATEAU_SAND_RADIUS.getInt();
        plateauHeight = TConfigOption.BIOME_BADLANDS_PLATEAU_HEIGHT.getInt();
        plateauFrequency = TConfigOption.BIOME_BADLANDS_PLATEAU_FREQUENCY.getFloat();
        plateauThreshold = TConfigOption.BIOME_BADLANDS_PLATEAU_THRESHOLD.getDouble();
        plateauCommonness = TConfigOption.BIOME_BADLANDS_PLATEAU_COMMONNESS.getDouble();
    }
}

