/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cave;

import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.terraform.biome.cave.AbstractCavePopulator;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.StalactiteBuilder;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class MossyCavePopulator
extends AbstractCavePopulator {
    @Override
    public void populate(TerraformWorld tw, Random random, SimpleBlock ceil, SimpleBlock floor) {
        Wall w;
        int h2;
        int caveHeight = ceil.getY() - floor.getY();
        if (Tag.SLABS.isTagged((Keyed)floor.getType()) || Tag.WALLS.isTagged((Keyed)floor.getType())) {
            return;
        }
        if (GenUtils.chance(random, 1, 25)) {
            h2 = caveHeight / 4;
            if (h2 < 1) {
                h2 = 1;
            }
            if (h2 > 4) {
                h2 = 4;
            }
            if ((w = new Wall(ceil)).getRelative(0, 1, 0).getType() == Material.SAND || w.getRelative(0, 1, 0).getType() == Material.SANDSTONE) {
                new StalactiteBuilder(Material.SANDSTONE_WALL).setSolidBlockType(Material.SANDSTONE).setFacingUp(false).setVerticalSpace(caveHeight).build(random, w);
            } else if (w.getUp().getType() == OneOneSevenBlockHandler.DEEPSLATE) {
                new StalactiteBuilder(OneOneSevenBlockHandler.COBBLED_DEEPSLATE_WALL).setSolidBlockType(OneOneSevenBlockHandler.DEEPSLATE).setFacingUp(false).setVerticalSpace(caveHeight).build(random, w);
            } else if (BlockUtils.isStoneLike(w.getUp().getType())) {
                new StalactiteBuilder(Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL).setSolidBlockType(Material.COBBLESTONE, Material.MOSSY_COBBLESTONE).setFacingUp(false).setVerticalSpace(caveHeight).build(random, w);
            }
        }
        if (GenUtils.chance(random, 1, 25)) {
            h2 = caveHeight / 4;
            if (h2 < 1) {
                h2 = 1;
            }
            if (h2 > 4) {
                h2 = 4;
            }
            if (BlockUtils.isAir((w = new Wall(floor.getRelative(0, 1, 0), BlockFace.NORTH)).getType())) {
                if (w.getRelative(0, -1, 0).getType() == Material.SAND || w.getRelative(0, 1, 0).getType() == Material.SANDSTONE) {
                    new StalactiteBuilder(Material.SANDSTONE_WALL).setSolidBlockType(Material.SANDSTONE).setFacingUp(true).setVerticalSpace(caveHeight).build(random, w);
                } else if (w.getDown().getType() == OneOneSevenBlockHandler.DEEPSLATE) {
                    new StalactiteBuilder(OneOneSevenBlockHandler.COBBLED_DEEPSLATE_WALL).setSolidBlockType(OneOneSevenBlockHandler.DEEPSLATE).setFacingUp(true).setVerticalSpace(caveHeight).build(random, w);
                } else if (BlockUtils.isStoneLike(w.getDown().getType())) {
                    new StalactiteBuilder(Material.COBBLESTONE_WALL, Material.MOSSY_COBBLESTONE_WALL).setSolidBlockType(Material.COBBLESTONE, Material.MOSSY_COBBLESTONE).setFacingUp(true).setVerticalSpace(caveHeight).build(random, w);
                }
            }
        } else if (GenUtils.chance(random, 1, 25) && BlockUtils.isStoneLike(floor.getRelative(0, 1, 0).getType())) {
            SimpleBlock base = floor.getRelative(0, 1, 0);
            if (BlockUtils.isAir(base.getType())) {
                for (BlockFace face : BlockUtils.directBlockFaces) {
                    if (!base.getRelative(face).getType().isSolid()) continue;
                    if (base.getRelative(0, -1, 0).getType() == OneOneSevenBlockHandler.DEEPSLATE) {
                        base.setType(OneOneSevenBlockHandler.COBBLED_DEEPSLATE_SLAB);
                    } else {
                        base.setType(Material.STONE_SLAB);
                    }
                    break;
                }
            }
        } else if (GenUtils.chance(random, 1, 35) && BlockUtils.isStoneLike(floor.getRelative(0, 1, 0).getType()) && BlockUtils.isAir(floor.getRelative(0, 1, 0).getType())) {
            floor.getRelative(0, 1, 0).setType(GenUtils.randMaterial(Material.RED_MUSHROOM, Material.BROWN_MUSHROOM));
        }
    }
}

