/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cave;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.cave.AbstractCavePopulator;
import org.terraform.biome.cave.CaveClusterRegistry;
import org.terraform.biome.cave.DeepCavePopulator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneSevenBlockHandler;
import org.terraform.utils.version.Version;

public class MasterCavePopulatorDistributor {
    private static ArrayList<Class<?>> populatedBefore = new ArrayList();

    public void populate(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        HashMap<SimpleLocation, CaveClusterRegistry> clusters = this.calculateClusterLocations(random, tw, data.getChunkX(), data.getChunkZ());
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                BiomeBank bank = tw.getBiomeBank(x, z);
                int maxHeightForCaves = bank.getHandler().getMaxHeightForCaves(tw, x, z);
                for (int[] pair : GenUtils.getCaveCeilFloors(data, x, z)) {
                    if (pair[0] > maxHeightForCaves || pair[0] - pair[1] <= 3) continue;
                    SimpleBlock ceil = new SimpleBlock(data, x, pair[0], z);
                    SimpleBlock floor = new SimpleBlock(data, x, pair[1], z);
                    if (Version.isAtLeast(17.0) && (floor.getType() == OneOneSevenBlockHandler.AMETHYST_BLOCK || floor.getType() == OneOneSevenBlockHandler.AMETHYST_CLUSTER || ceil.getType() == OneOneSevenBlockHandler.AMETHYST_BLOCK || ceil.getType() == OneOneSevenBlockHandler.AMETHYST_CLUSTER)) continue;
                    AbstractCavePopulator pop = null;
                    if (floor.getY() < TerraformGeneratorPlugin.injector.getMinY() + 32) {
                        pop = new DeepCavePopulator();
                    } else {
                        for (SimpleLocation loc : clusters.keySet()) {
                            if (loc.getX() != x || loc.getZ() != z) continue;
                            pop = clusters.get(loc).getPopulator(random);
                        }
                        if (pop == null) {
                            pop = bank.getCavePop();
                        }
                    }
                    if (pop == null) continue;
                    pop.populate(tw, random, ceil, floor);
                    if (populatedBefore.contains(pop.getClass())) continue;
                    populatedBefore.add(pop.getClass());
                    TerraformGeneratorPlugin.logger.info("Spawning " + pop.getClass().getSimpleName() + " at " + floor);
                }
            }
        }
    }

    private HashMap<SimpleLocation, CaveClusterRegistry> calculateClusterLocations(Random rand, TerraformWorld tw, int chunkX, int chunkZ) {
        HashMap<SimpleLocation, CaveClusterRegistry> locs = new HashMap<SimpleLocation, CaveClusterRegistry>();
        for (CaveClusterRegistry type : CaveClusterRegistry.values()) {
            SimpleLocation[] positions;
            for (SimpleLocation pos : positions = GenUtils.randomObjectPositions(tw.getHashedRand(type.getHashSeed(), chunkX, chunkZ).nextInt(99999), chunkX, chunkZ, type.getSeparation(), type.getPertub())) {
                if (locs.containsKey(pos) && rand.nextBoolean()) continue;
                locs.put(pos, type);
            }
        }
        return locs;
    }
}

