/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cave;

import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.terraform.biome.cave.AbstractCaveClusterPopulator;
import org.terraform.coregen.populatordata.PopulatorDataICABiomeWriterAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.tree.TreeDB;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.blockdata.BisectedBuilder;
import org.terraform.utils.blockdata.DirectionalBuilder;
import org.terraform.utils.blockdata.MultipleFacingBuilder;
import org.terraform.utils.version.OneOneSevenBlockHandler;
import org.terraform.utils.version.Version;

public class LushClusterCavePopulator
extends AbstractCaveClusterPopulator {
    private boolean isForLargeCave;

    public LushClusterCavePopulator(float radius, boolean isForLargeCave) {
        super(radius);
        this.isForLargeCave = isForLargeCave;
    }

    @Override
    public void oneUnit(TerraformWorld tw, Random random, SimpleBlock ceil, SimpleBlock floor) {
        int caveHeight = ceil.getY() - floor.getY();
        if (!BlockUtils.isWet(ceil.getRelative(0, -1, 0))) {
            SimpleBlock base;
            if (Tag.SLABS.isTagged((Keyed)floor.getType()) || Tag.WALLS.isTagged((Keyed)floor.getType())) {
                return;
            }
            if (GenUtils.chance(random, 1, 8)) {
                ceil.setType(OneOneSevenBlockHandler.ROOTED_DIRT);
                if (random.nextBoolean()) {
                    ceil.getRelative(0, -1, 0).setType(OneOneSevenBlockHandler.HANGING_ROOTS);
                }
            } else {
                ceil.setType(OneOneSevenBlockHandler.MOSS_BLOCK);
                for (BlockFace face : BlockUtils.sixBlockFaces) {
                    if (ceil.getRelative(face).getType() != Material.LAVA) continue;
                    ceil.getRelative(face).setType(Material.AIR);
                }
                if (GenUtils.chance(random, 1, 15)) {
                    ceil.getRelative(0, -1, 0).setType(OneOneSevenBlockHandler.SPORE_BLOSSOM);
                }
            }
            if (this.isForLargeCave && GenUtils.chance(random, 1, 300) && BlockUtils.isDirtLike((base = ceil.getGround()).getType()) && !BlockUtils.isWet(base.getRelative(0, 1, 0))) {
                TreeDB.spawnAzalea(random, tw, base.getPopData(), base.getX(), base.getY() + 1, base.getZ());
            }
            int glowBerryChance = 5;
            if (this.isForLargeCave) {
                glowBerryChance = 15;
            }
            if (GenUtils.chance(random, 1, glowBerryChance)) {
                int h2 = caveHeight / 4;
                if (h2 < 1) {
                    h2 = 1;
                }
                if (h2 > 6) {
                    h2 = 6;
                }
                OneOneSevenBlockHandler.downLCaveVines(h2, ceil.getRelative(0, -1, 0));
            }
        }
        if (BlockUtils.isWet(floor.getRelative(0, 1, 0))) {
            if (!this.isForLargeCave) {
                floor.setType(Material.CLAY);
            }
            return;
        }
        floor.setType(OneOneSevenBlockHandler.MOSS_BLOCK);
        if (GenUtils.chance(random, 1, 15)) {
            if (random.nextBoolean()) {
                floor.getRelative(0, 1, 0).setType(OneOneSevenBlockHandler.AZALEA);
            } else {
                floor.getRelative(0, 1, 0).setType(OneOneSevenBlockHandler.FLOWERING_AZALEA);
            }
        } else if (Version.isAtLeast(17.0) && GenUtils.chance(random, 1, 7)) {
            if (random.nextBoolean()) {
                new DirectionalBuilder(OneOneSevenBlockHandler.BIG_DRIPLEAF).setFacing(BlockUtils.getDirectBlockFace(random)).apply(floor.getRelative(0, 1, 0));
            } else {
                new BisectedBuilder(OneOneSevenBlockHandler.SMALL_DRIPLEAF).placeBoth(floor.getRelative(0, 1, 0));
            }
        } else if (GenUtils.chance(random, 1, 6)) {
            floor.getRelative(0, 1, 0).setType(Material.GRASS);
        } else if (GenUtils.chance(random, 1, 7)) {
            floor.getRelative(0, 1, 0).setType(OneOneSevenBlockHandler.MOSS_CARPET);
        }
        SimpleBlock target = floor;
        while (target.getY() != ceil.getY()) {
            for (BlockFace face : BlockUtils.directBlockFaces) {
                SimpleBlock rel = target.getRelative(face);
                if (!BlockUtils.isStoneLike(rel.getType())) continue;
                rel.setType(OneOneSevenBlockHandler.MOSS_BLOCK);
                if (!BlockUtils.isAir(target.getType()) || !GenUtils.chance(random, 1, 5)) continue;
                new MultipleFacingBuilder(OneOneSevenBlockHandler.GLOW_LICHEN).setFace(face, true).apply(target);
            }
            target = target.getRelative(0, 1, 0);
        }
        if (TerraformGeneratorPlugin.injector.getICAData(ceil.getPopData()) instanceof PopulatorDataICABiomeWriterAbstract) {
            PopulatorDataICABiomeWriterAbstract data = (PopulatorDataICABiomeWriterAbstract)TerraformGeneratorPlugin.injector.getICAData(ceil.getPopData());
            while (floor.getY() < ceil.getY()) {
                data.setBiome(floor.getX(), floor.getY(), floor.getZ(), OneOneSevenBlockHandler.LUSH_CAVES);
                floor = floor.getRelative(0, 1, 0);
            }
        }
    }
}

