/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cave;

import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockFace;
import org.terraform.biome.cave.AbstractCavePopulator;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.utils.GenUtils;
import org.terraform.utils.StalactiteBuilder;

public class FrozenCavePopulator
extends AbstractCavePopulator {
    @Override
    public void populate(TerraformWorld tw, Random random, SimpleBlock ceil, SimpleBlock floor) {
        Wall w;
        int h2;
        int caveHeight = ceil.getY() - floor.getY();
        if (Tag.SLABS.isTagged((Keyed)floor.getType()) || Tag.WALLS.isTagged((Keyed)floor.getType())) {
            return;
        }
        ceil.setType(Material.ICE);
        if (GenUtils.chance(random, 1, 24)) {
            h2 = caveHeight / 4;
            if (h2 < 1) {
                h2 = 1;
            }
            w = new Wall(ceil.getRelative(0, -1, 0), BlockFace.NORTH);
            new StalactiteBuilder(Material.ICE).setSolidBlockType(Material.ICE).setFacingUp(false).setVerticalSpace(caveHeight).build(random, w);
        }
        floor.getRelative(0, 1, 0).setType(Material.ICE);
        if (GenUtils.chance(random, 1, 25)) {
            h2 = caveHeight / 4;
            if (h2 < 1) {
                h2 = 1;
            }
            if ((w = new Wall(floor.getRelative(0, 2, 0))).getType() == Material.CAVE_AIR) {
                new StalactiteBuilder(Material.ICE).setSolidBlockType(Material.ICE).setFacingUp(true).setVerticalSpace(caveHeight).build(random, w);
            }
        }
    }
}

