/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cave;

import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.terraform.biome.cave.AbstractCavePopulator;
import org.terraform.biome.cave.MossyCavePopulator;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.CylinderBuilder;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class ForestedMountainsCavePopulator
extends AbstractCavePopulator {
    private MossyCavePopulator mossyCavePop = new MossyCavePopulator();

    @Override
    public void populate(TerraformWorld tw, Random random, SimpleBlock ceil, SimpleBlock floor) {
        if (ceil.getY() > TerraformGenerator.seaLevel && floor.getY() < TerraformGenerator.seaLevel && ceil.getAtY(TerraformGenerator.seaLevel).getType() == Material.WATER) {
            int h2;
            int caveHeight = ceil.getY() - TerraformGenerator.seaLevel - 1;
            if (caveHeight <= 2) {
                return;
            }
            if (GenUtils.chance(random, 1, 100)) {
                new CylinderBuilder(random, floor.getRelative(0, (ceil.getY() - floor.getY()) / 2, 0), Material.STONE).setRadius(1.5f).setRY((ceil.getY() - floor.getY()) / 2 + 3).setHardReplace(false).build();
                return;
            }
            int glowBerryChance = 15;
            if (GenUtils.chance(random, 1, glowBerryChance) && (h2 = caveHeight / 2) > 0) {
                if (h2 > 6) {
                    h2 = 6;
                }
                OneOneSevenBlockHandler.downLCaveVines(h2, ceil);
            }
            if (GenUtils.chance(random, 1, 30)) {
                ceil.setType(OneOneSevenBlockHandler.SPORE_BLOSSOM);
            }
            if (GenUtils.chance(random, 1, 50)) {
                ceil.getAtY(TerraformGenerator.seaLevel + 1).lsetType(Material.LILY_PAD);
            }
            if (Tag.SLABS.isTagged((Keyed)floor.getType()) || Tag.WALLS.isTagged((Keyed)floor.getType())) {
                return;
            }
            if (GenUtils.chance(random, 1, 20)) {
                CoralGenerator.generateSeaPickles(floor.getPopData(), floor.getX(), floor.getY() + 1, floor.getZ());
            }
            return;
        }
        this.mossyCavePop.populate(tw, random, ceil, floor);
    }
}

