/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cave;

import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.terraform.biome.cave.AbstractCaveClusterPopulator;
import org.terraform.coregen.populatordata.PopulatorDataICABiomeWriterAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.main.TerraformGeneratorPlugin;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneSevenBlockHandler;

public class DripstoneClusterCavePopulator
extends AbstractCaveClusterPopulator {
    public DripstoneClusterCavePopulator(float radius) {
        super(radius);
    }

    @Override
    protected void oneUnit(TerraformWorld tw, Random random, SimpleBlock ceil, SimpleBlock floor) {
        int h2;
        int caveHeight = ceil.getY() - floor.getY();
        if (Tag.SLABS.isTagged((Keyed)floor.getType()) || Tag.WALLS.isTagged((Keyed)floor.getType())) {
            return;
        }
        ceil.setType(OneOneSevenBlockHandler.DRIPSTONE_BLOCK);
        if (GenUtils.chance(random, 1, 4)) {
            h2 = caveHeight / 4;
            if (h2 < 1) {
                h2 = 1;
            }
            if (h2 > 4) {
                h2 = 4;
            }
            OneOneSevenBlockHandler.downLPointedDripstone(GenUtils.randInt(1, h2), ceil.getRelative(0, -1, 0));
        }
        floor.setType(OneOneSevenBlockHandler.DRIPSTONE_BLOCK);
        if (GenUtils.chance(random, 1, 4)) {
            h2 = caveHeight / 4;
            if (h2 < 1) {
                h2 = 1;
            }
            if (h2 > 4) {
                h2 = 4;
            }
            OneOneSevenBlockHandler.upLPointedDripstone(GenUtils.randInt(1, h2), floor.getRelative(0, 1, 0));
        }
        if (TerraformGeneratorPlugin.injector.getICAData(ceil.getPopData()) instanceof PopulatorDataICABiomeWriterAbstract) {
            PopulatorDataICABiomeWriterAbstract data = (PopulatorDataICABiomeWriterAbstract)TerraformGeneratorPlugin.injector.getICAData(ceil.getPopData());
            while (floor.getY() < ceil.getY()) {
                data.setBiome(floor.getX(), floor.getY(), floor.getZ(), OneOneSevenBlockHandler.DRIPSTONE_CAVES);
                floor = floor.getRelative(0, 1, 0);
            }
        }
    }
}

