/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.cave;

import java.util.ArrayList;
import java.util.Random;
import org.terraform.biome.cave.AbstractCavePopulator;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;
import org.terraform.utils.version.OneOneSevenBlockHandler;
import org.terraform.utils.version.Version;

public abstract class AbstractCaveClusterPopulator
extends AbstractCavePopulator {
    private float radius;

    public AbstractCaveClusterPopulator(float radius) {
        this.radius = radius;
    }

    protected abstract void oneUnit(TerraformWorld var1, Random var2, SimpleBlock var3, SimpleBlock var4);

    @Override
    public void populate(TerraformWorld tw, Random random, SimpleBlock ceil, SimpleBlock floor) {
        ArrayList<SimpleBlock[]> ceilFloorPairs = new ArrayList<SimpleBlock[]>();
        FastNoise circleNoise = NoiseCacheHandler.getNoise(tw, NoiseCacheHandler.NoiseCacheEntry.BIOME_CAVECLUSTER_CIRCLENOISE, world -> {
            FastNoise n = new FastNoise((int)(world.getSeed() * 11L));
            n.SetNoiseType(FastNoise.NoiseType.Simplex);
            n.SetFrequency(0.09f);
            return n;
        });
        SimpleBlock center = new SimpleBlock(ceil.getPopData(), ceil.getX(), (ceil.getY() + floor.getY()) / 2, ceil.getZ());
        for (float x = -this.radius; x <= this.radius; x += 1.0f) {
            for (float z = -this.radius; z <= this.radius; z += 1.0f) {
                SimpleBlock rel = center.getRelative(Math.round(x), 0, Math.round(z));
                double equationResult = Math.pow(x, 2.0) / Math.pow(this.radius, 2.0) + Math.pow(z, 2.0) / Math.pow(this.radius, 2.0);
                if (!(equationResult <= 1.0 + 0.7 * (double)circleNoise.GetNoise(rel.getX(), rel.getZ()))) continue;
                Wall candidateFloorWall = new Wall(rel).findStonelikeFloor(60);
                Wall candidateCeilWall = new Wall(rel).findStonelikeCeiling(60);
                if (candidateFloorWall == null || candidateCeilWall == null) continue;
                SimpleBlock candidateCeil = candidateCeilWall.get();
                SimpleBlock candidateFloor = candidateFloorWall.get();
                if (Version.isAtLeast(17.0) && (candidateFloor.getType() == OneOneSevenBlockHandler.AMETHYST_BLOCK || candidateFloor.getType() == OneOneSevenBlockHandler.AMETHYST_CLUSTER || candidateCeil.getType() == OneOneSevenBlockHandler.AMETHYST_BLOCK || candidateCeil.getType() == OneOneSevenBlockHandler.AMETHYST_CLUSTER) || candidateFloor.getType() == OneOneSevenBlockHandler.MOSS_BLOCK || candidateFloor.getType() == OneOneSevenBlockHandler.DRIPSTONE_BLOCK || candidateFloor.getRelative(0, 1, 0).getType().isSolid() || candidateCeil.getRelative(0, -1, 0).getType().isSolid() || candidateCeil.getY() - 1 <= candidateFloor.getY() + 1) continue;
                ceilFloorPairs.add(new SimpleBlock[]{candidateCeil, candidateFloor});
            }
        }
        for (SimpleBlock[] candidates : ceilFloorPairs) {
            this.oneUnit(tw, random, candidates[0], candidates[1]);
        }
    }
}

