/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.beach;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleLocation;
import org.terraform.data.TerraformWorld;
import org.terraform.tree.TreeDB;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class SandyBeachHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.BEACH;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.SAND, Material.SAND, GenUtils.randMaterial(rand, Material.SANDSTONE, Material.SAND, Material.SAND, Material.SAND, Material.SAND, Material.SAND), GenUtils.randMaterial(rand, Material.SANDSTONE, Material.STONE), GenUtils.randMaterial(rand, Material.SANDSTONE, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        boolean hasSugarcane = GenUtils.chance(random, 1, 100);
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                Material base;
                int y = GenUtils.getTrueHighestBlock(data, x, z);
                if (data.getBiome(x, z) != this.getBiome() || (base = data.getType(x, y, z)) != Material.SAND && base != Material.GRASS_BLOCK) continue;
                ++y;
                if (!hasSugarcane) continue;
                boolean hasWater = false;
                if (data.getType(x + 1, y - 1, z) == Material.WATER) {
                    hasWater = true;
                }
                if (data.getType(x - 1, y - 1, z) == Material.WATER) {
                    hasWater = true;
                }
                if (data.getType(x, y - 1, z + 1) == Material.WATER) {
                    hasWater = true;
                }
                if (data.getType(x, y - 1, z - 1) == Material.WATER) {
                    hasWater = true;
                }
                if (!hasWater) continue;
                BlockUtils.spawnPillar(random, data, x, y, z, Material.SUGAR_CANE, 3, 7);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        SimpleLocation[] coconutTrees;
        for (SimpleLocation sLoc : coconutTrees = GenUtils.randomObjectPositions(tw, data.getChunkX(), data.getChunkZ(), 20)) {
            int treeY = GenUtils.getHighestGround(data, sLoc.getX(), sLoc.getZ());
            sLoc.setY(treeY);
            if (data.getBiome(sLoc.getX(), sLoc.getZ()) != this.getBiome() || !BlockUtils.isDirtLike(data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ())) && data.getType(sLoc.getX(), sLoc.getY(), sLoc.getZ()) != Material.SAND) continue;
            TreeDB.spawnCoconutTree(tw, data, sLoc.getX(), sLoc.getY() + 1, sLoc.getZ());
        }
    }
}

