/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.beach;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;
import org.terraform.biome.BiomeBank;
import org.terraform.coregen.HeightMap;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.tree.TreeDB;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.noise.FastNoise;
import org.terraform.utils.noise.NoiseCacheHandler;

public class OasisBeach {
    public static final double oasisThreshold = (2.0 - TConfigOption.BIOME_OASIS_COMMONNESS.getDouble()) * 0.31;
    private static final float oasisFrequency = TConfigOption.BIOME_OASIS_FREQUENCY.getFloat();

    public static void transformTerrain(TerraformWorld tw, ChunkGenerator.BiomeGrid biome, int chunkX, int chunkZ, BiomeBank targetBiome) {
        for (int x = chunkX * 16; x < chunkX * 16 + 16; ++x) {
            for (int z = chunkZ * 16; z < chunkZ * 16 + 16; ++z) {
                int height = HeightMap.getBlockHeight(tw, x, z);
                if (!OasisBeach.isOasisBeach(tw, x, z, targetBiome)) continue;
                for (int y = height; y < height + 35; ++y) {
                    biome.setBiome(x, y, z, Biome.JUNGLE);
                }
            }
        }
    }

    public static float getOasisNoise(TerraformWorld world, int x, int z) {
        FastNoise lushRiversNoise = NoiseCacheHandler.getNoise(world, NoiseCacheHandler.NoiseCacheEntry.BIOME_DESERT_LUSH_RIVER, w -> {
            FastNoise n = new FastNoise((int)((double)w.getSeed() * 0.4));
            n.SetNoiseType(FastNoise.NoiseType.Cubic);
            n.SetFrequency(oasisFrequency);
            return n;
        });
        return lushRiversNoise.GetNoise(x, z);
    }

    private static boolean isOasisBeach(TerraformWorld tw, int x, int z, BiomeBank targetBiome) {
        double lushRiverNoiseValue = OasisBeach.getOasisNoise(tw, x, z);
        double riverDepth = HeightMap.getRawRiverDepth(tw, x, z);
        BiomeBank biome = BiomeBank.calculateHeightIndependentBiome(tw, x, z);
        return lushRiverNoiseValue > oasisThreshold && riverDepth > 0.0 && biome == targetBiome;
    }

    public static void generateOasisBeach(TerraformWorld tw, Random random, PopulatorDataAbstract data, int x, int z, BiomeBank targetBiome) {
        if (!OasisBeach.isOasisBeach(tw, x, z, targetBiome)) {
            return;
        }
        int y = GenUtils.getHighestGround(data, x, z);
        int aboveSea = y - TerraformGenerator.seaLevel;
        boolean isGrass = false;
        if (1.0 - (double)aboveSea / 8.0 > random.nextDouble() && y >= TerraformGenerator.seaLevel) {
            data.setType(x, y, z, Material.GRASS_BLOCK);
            isGrass = true;
        }
        if (y == TerraformGenerator.seaLevel && random.nextInt(3) == 0) {
            BlockUtils.spawnPillar(random, data, x, y + 1, z, Material.SUGAR_CANE, 1, 4);
        } else if (y >= TerraformGenerator.seaLevel) {
            if (random.nextInt(8) == 0) {
                TreeDB.spawnCoconutTree(tw, data, x, y, z);
            } else if (random.nextInt(5) == 0) {
                OasisBeach.createBush(random, data, x, y, z, GenUtils.randDouble(random, 1.7, 3.0), GenUtils.randDouble(random, 2.0, 2.8), GenUtils.randDouble(random, 1.7, 3.0), Material.JUNGLE_LEAVES, Material.JUNGLE_LOG, 0.7);
            } else if (isGrass) {
                data.setType(x, y + 1, z, GenUtils.randMaterial(random, Material.GRASS, Material.GRASS, Material.GRASS, Material.FERN));
            }
        }
    }

    public static void createBush(Random random, PopulatorDataAbstract data, int x, int y, int z, double xRadius, double yRadius, double zRadius, Material leaves, Material stem, double density) {
        int ny = y;
        while ((double)ny < (double)y + yRadius / 2.0) {
            data.setType(x, ny, z, stem);
            ++ny;
        }
        int xr = (int)(-Math.ceil(xRadius));
        while ((double)xr < Math.ceil(xRadius)) {
            int yr = (int)(-Math.ceil(yRadius));
            while ((double)yr < Math.ceil(yRadius)) {
                int zr = (int)(-Math.ceil(zRadius));
                while ((double)zr < Math.ceil(zRadius)) {
                    double distToCenter = Math.sqrt((double)(xr * xr) / (xRadius * xRadius) + (double)(yr * yr) / (yRadius * yRadius) + (double)(zr * zr) / (zRadius * zRadius));
                    if (distToCenter < 1.0 && random.nextDouble() < 1.0 - distToCenter + density) {
                        data.lsetType(x + xr, y + yr, z + zr, leaves);
                    }
                    ++zr;
                }
                ++yr;
            }
            ++xr;
        }
    }
}

