/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.beach;

import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.main.config.TConfigOption;
import org.terraform.structure.small.WitchHutPopulator;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneNineBlockHandler;

public class MudflatsHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return OneOneNineBlockHandler.MANGROVE_SWAMP;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{GenUtils.weightedRandomMaterial(rand, OneOneNineBlockHandler.MUD, 35, Material.GRASS_BLOCK, 10), GenUtils.randMaterial(rand, Material.DIRT), GenUtils.randMaterial(rand, Material.DIRT), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        boolean spawnHut = GenUtils.chance(tw.getHashedRand(data.getChunkX(), data.getChunkZ(), 66666), TConfigOption.STRUCTURES_SWAMPHUT_CHANCE_OUT_OF_TEN_THOUSAND.getInt(), 10000);
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                int y = GenUtils.getHighestGround(data, x, z);
                if (data.getBiome(x, z) != this.getBiome() || data.getType(x, ++y, z) != Material.AIR) continue;
                if (GenUtils.chance(5, 100)) {
                    if (random.nextBoolean()) {
                        BlockUtils.setDoublePlant(data, x, y, z, Material.TALL_GRASS);
                    } else {
                        data.setType(x, y, z, Material.GRASS);
                    }
                }
                if (!spawnHut || !TConfigOption.STRUCTURES_SWAMPHUT_SPAWN_MUDFLAT_HEADS.getBoolean() || !GenUtils.chance(10, 100) || !BlockUtils.isDirtLike(data.getType(x, y - 1, z))) continue;
                Rotatable skull = (Rotatable)Bukkit.createBlockData((Material)Material.PLAYER_HEAD);
                skull.setRotation(BlockUtils.getXZPlaneBlockFace(random));
                data.setType(x, y, z, OneOneNineBlockHandler.MANGROVE_FENCE);
                data.setBlockData(x, y + 1, z, (BlockData)skull);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        boolean spawnHut = GenUtils.chance(tw.getHashedRand(data.getChunkX(), data.getChunkZ(), 66666), TConfigOption.STRUCTURES_SWAMPHUT_CHANCE_OUT_OF_TEN_THOUSAND.getInt(), 10000);
        if (spawnHut) {
            WitchHutPopulator whp = new WitchHutPopulator();
            whp.populate(tw, random, data);
        }
    }
}

