/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.beach;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.terraform.biome.BiomeHandler;
import org.terraform.biome.custombiomes.CustomBiomeType;
import org.terraform.biome.flat.MuddyBogHandler;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.SimpleBlock;
import org.terraform.data.TerraformWorld;
import org.terraform.data.Wall;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.GenUtils;

public class BogBeachHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return Biome.SWAMP;
    }

    @Override
    public CustomBiomeType getCustomBiome() {
        return CustomBiomeType.MUDDY_BOG;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.GRASS_BLOCK, GenUtils.randMaterial(rand, Material.DIRT), GenUtils.randMaterial(rand, Material.DIRT), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE), GenUtils.randMaterial(rand, Material.DIRT, Material.STONE)};
    }

    @Override
    public void populateSmallItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                SimpleBlock block;
                int y = GenUtils.getHighestGround(data, x, z);
                if (data.getBiome(x, z) != this.getBiome() || BlockUtils.isWet((block = new SimpleBlock(data, x, y, z)).getRelative(0, 1, 0))) continue;
                if (GenUtils.chance(random, 1, 85)) {
                    block.getRelative(0, 1, 0).setType(Material.DEAD_BUSH);
                    continue;
                }
                if (GenUtils.chance(random, 1, 85)) {
                    block.getRelative(0, 1, 0).setType(Material.BROWN_MUSHROOM);
                    continue;
                }
                if (GenUtils.chance(random, 1, 85)) {
                    block.getRelative(0, 1, 0).setType(Material.GRASS);
                    continue;
                }
                if (GenUtils.chance(random, 1, 85)) {
                    BlockUtils.setDoublePlant(data, x, y + 1, z, Material.TALL_GRASS);
                    continue;
                }
                for (BlockFace face : BlockUtils.directBlockFaces) {
                    if (!GenUtils.chance(random, 1, 75) || !BlockUtils.isWet(block.getRelative(face))) continue;
                    new Wall(block.getRelative(0, 1, 0)).LPillar(GenUtils.randInt(2, 5), random, Material.SUGAR_CANE);
                }
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
        new MuddyBogHandler().populateLargeItems(tw, random, data);
    }
}

