/*
 * Decompiled with CFR 0.152.
 */
package org.terraform.biome.beach;

import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.terraform.biome.BiomeHandler;
import org.terraform.coregen.bukkit.TerraformGenerator;
import org.terraform.coregen.populatordata.PopulatorDataAbstract;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.BlockUtils;
import org.terraform.utils.CoralGenerator;
import org.terraform.utils.GenUtils;
import org.terraform.utils.version.OneOneEightBlockHandler;

public class BlackOceanBeachHandler
extends BiomeHandler {
    @Override
    public boolean isOcean() {
        return false;
    }

    @Override
    public Biome getBiome() {
        return OneOneEightBlockHandler.STONY_SHORE;
    }

    @Override
    public Material[] getSurfaceCrust(Random rand) {
        return new Material[]{Material.STONE};
    }

    @Override
    public void populateSmallItems(TerraformWorld world, Random random, PopulatorDataAbstract data) {
        for (int x = data.getChunkX() * 16; x < data.getChunkX() * 16 + 16; ++x) {
            for (int z = data.getChunkZ() * 16; z < data.getChunkZ() * 16 + 16; ++z) {
                if (data.getBiome(x, z) != this.getBiome()) continue;
                int y = GenUtils.getHighestGround(data, x, z);
                if (y >= TerraformGenerator.seaLevel - 2) {
                    data.setType(x, y, z, Material.GRAVEL);
                } else if (y >= TerraformGenerator.seaLevel - 4 && random.nextBoolean()) {
                    data.setType(x, y, z, Material.GRAVEL);
                }
                if (y > TerraformGenerator.seaLevel || !BlockUtils.isStoneLike(data.getType(x, y, z)) || !GenUtils.chance(random, 1, 80)) continue;
                CoralGenerator.generateKelpGrowth(data, x, y + 1, z);
            }
        }
    }

    @Override
    public void populateLargeItems(TerraformWorld tw, Random random, PopulatorDataAbstract data) {
    }
}

